/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ResourceStridedSliceAssign", inputsClass=Inputs.class)
public final class ResourceStridedSliceAssign
extends RawOp {
    public static final String OP_NAME = "ResourceStridedSliceAssign";

    public ResourceStridedSliceAssign(Operation operation) {
        super(operation, OP_NAME);
    }

    public static <T extends TNumber> ResourceStridedSliceAssign create(Scope scope, Operand<? extends TType> ref, Operand<T> begin, Operand<T> end, Operand<T> strides, Operand<? extends TType> value, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(ref.asOutput());
        opBuilder.addInput(begin.asOutput());
        opBuilder.addInput(end.asOutput());
        opBuilder.addInput(strides.asOutput());
        opBuilder.addInput(value.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.beginMask != null) {
                    opBuilder.setAttr("begin_mask", opts.beginMask);
                }
                if (opts.endMask != null) {
                    opBuilder.setAttr("end_mask", opts.endMask);
                }
                if (opts.ellipsisMask != null) {
                    opBuilder.setAttr("ellipsis_mask", opts.ellipsisMask);
                }
                if (opts.newAxisMask != null) {
                    opBuilder.setAttr("new_axis_mask", opts.newAxisMask);
                }
                if (opts.shrinkAxisMask == null) continue;
                opBuilder.setAttr("shrink_axis_mask", opts.shrinkAxisMask);
            }
        }
        return new ResourceStridedSliceAssign(opBuilder.build());
    }

    public static Options beginMask(Long beginMask) {
        return new Options().beginMask(beginMask);
    }

    public static Options endMask(Long endMask) {
        return new Options().endMask(endMask);
    }

    public static Options ellipsisMask(Long ellipsisMask) {
        return new Options().ellipsisMask(ellipsisMask);
    }

    public static Options newAxisMask(Long newAxisMask) {
        return new Options().newAxisMask(newAxisMask);
    }

    public static Options shrinkAxisMask(Long shrinkAxisMask) {
        return new Options().shrinkAxisMask(shrinkAxisMask);
    }

    @OpInputsMetadata(outputsClass=ResourceStridedSliceAssign.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ResourceStridedSliceAssign> {
        public final Operand<? extends TType> ref;
        public final Operand<T> begin;
        public final Operand<T> end;
        public final Operand<T> strides;
        public final Operand<? extends TType> value;
        public final DataType T;
        public final DataType Index;
        public final long beginMask;
        public final long endMask;
        public final long ellipsisMask;
        public final long newAxisMask;
        public final long shrinkAxisMask;

        public Inputs(GraphOperation op) {
            super(new ResourceStridedSliceAssign(op), op, Arrays.asList("T", "Index", "begin_mask", "end_mask", "ellipsis_mask", "new_axis_mask", "shrink_axis_mask"));
            int inputIndex = 0;
            this.ref = op.input(inputIndex++);
            this.begin = op.input(inputIndex++);
            this.end = op.input(inputIndex++);
            this.strides = op.input(inputIndex++);
            this.value = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Index = op.attributes().getAttrType("Index");
            this.beginMask = op.attributes().getAttrInt("begin_mask");
            this.endMask = op.attributes().getAttrInt("end_mask");
            this.ellipsisMask = op.attributes().getAttrInt("ellipsis_mask");
            this.newAxisMask = op.attributes().getAttrInt("new_axis_mask");
            this.shrinkAxisMask = op.attributes().getAttrInt("shrink_axis_mask");
        }
    }

    public static class Options {
        private Long beginMask;
        private Long endMask;
        private Long ellipsisMask;
        private Long newAxisMask;
        private Long shrinkAxisMask;

        private Options() {
        }

        public Options beginMask(Long beginMask) {
            this.beginMask = beginMask;
            return this;
        }

        public Options endMask(Long endMask) {
            this.endMask = endMask;
            return this;
        }

        public Options ellipsisMask(Long ellipsisMask) {
            this.ellipsisMask = ellipsisMask;
            return this;
        }

        public Options newAxisMask(Long newAxisMask) {
            this.newAxisMask = newAxisMask;
            return this;
        }

        public Options shrinkAxisMask(Long shrinkAxisMask) {
            this.shrinkAxisMask = shrinkAxisMask;
            return this;
        }
    }
}

