/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Empty", inputsClass=Inputs.class)
public final class Empty<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Empty";
    private Output<T> output;

    public Empty(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Empty<T> create(Scope scope, Operand<TInt32> shape, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(shape.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.init == null) continue;
                opBuilder.setAttr("init", opts.init);
            }
        }
        return new Empty<T>(opBuilder.build());
    }

    public static Options init(Boolean init) {
        return new Options().init(init);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Empty.class)
    public static class Inputs
    extends RawOpInputs<Empty<?>> {
        public final Operand<TInt32> shape;
        public final DataType dtype;
        public final boolean init;

        public Inputs(GraphOperation op) {
            super(new Empty(op), op, Arrays.asList("dtype", "init"));
            int inputIndex = 0;
            this.shape = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.init = op.attributes().getAttrBool("init");
        }
    }

    public static class Options {
        private Boolean init;

        private Options() {
        }

        public Options init(Boolean init) {
            this.init = init;
            return this;
        }
    }
}

