/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.summary.AudioSummary;
import org.tensorflow.op.summary.CloseSummaryWriter;
import org.tensorflow.op.summary.CreateSummaryDbWriter;
import org.tensorflow.op.summary.CreateSummaryFileWriter;
import org.tensorflow.op.summary.FlushSummaryWriter;
import org.tensorflow.op.summary.HistogramSummary;
import org.tensorflow.op.summary.ImageSummary;
import org.tensorflow.op.summary.ImportEvent;
import org.tensorflow.op.summary.MergeSummary;
import org.tensorflow.op.summary.ScalarSummary;
import org.tensorflow.op.summary.StatsAggregatorSummary;
import org.tensorflow.op.summary.SummaryWriter;
import org.tensorflow.op.summary.TensorSummary;
import org.tensorflow.op.summary.WriteAudioSummary;
import org.tensorflow.op.summary.WriteGraphSummary;
import org.tensorflow.op.summary.WriteHistogramSummary;
import org.tensorflow.op.summary.WriteImageSummary;
import org.tensorflow.op.summary.WriteRawProtoSummary;
import org.tensorflow.op.summary.WriteScalarSummary;
import org.tensorflow.op.summary.WriteSummary;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class SummaryOps {
    private final Scope scope;
    private final Ops ops;

    SummaryOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public AudioSummary audioSummary(Operand<TString> tag, Operand<TFloat32> tensor, Operand<TFloat32> sampleRate, AudioSummary.Options ... options) {
        return AudioSummary.create(this.scope, tag, tensor, sampleRate, options);
    }

    public CloseSummaryWriter closeSummaryWriter(Operand<? extends TType> writer) {
        return CloseSummaryWriter.create(this.scope, writer);
    }

    public CreateSummaryDbWriter createSummaryDbWriter(Operand<? extends TType> writer, Operand<TString> dbUri, Operand<TString> experimentName, Operand<TString> runName, Operand<TString> userName) {
        return CreateSummaryDbWriter.create(this.scope, writer, dbUri, experimentName, runName, userName);
    }

    public CreateSummaryFileWriter createSummaryFileWriter(Operand<? extends TType> writer, Operand<TString> logdir, Operand<TInt32> maxQueue, Operand<TInt32> flushMillis, Operand<TString> filenameSuffix) {
        return CreateSummaryFileWriter.create(this.scope, writer, logdir, maxQueue, flushMillis, filenameSuffix);
    }

    public FlushSummaryWriter flushSummaryWriter(Operand<? extends TType> writer) {
        return FlushSummaryWriter.create(this.scope, writer);
    }

    public HistogramSummary histogramSummary(Operand<TString> tag, Operand<? extends TNumber> values) {
        return HistogramSummary.create(this.scope, tag, values);
    }

    public ImageSummary imageSummary(Operand<TString> tag, Operand<? extends TNumber> tensor, ImageSummary.Options ... options) {
        return ImageSummary.create(this.scope, tag, tensor, options);
    }

    public ImportEvent importEvent(Operand<? extends TType> writer, Operand<TString> event) {
        return ImportEvent.create(this.scope, writer, event);
    }

    public MergeSummary mergeSummary(Iterable<Operand<TString>> inputs) {
        return MergeSummary.create(this.scope, inputs);
    }

    public ScalarSummary scalarSummary(Operand<TString> tags, Operand<? extends TNumber> values) {
        return ScalarSummary.create(this.scope, tags, values);
    }

    public StatsAggregatorSummary statsAggregatorSummary(Operand<? extends TType> iterator) {
        return StatsAggregatorSummary.create(this.scope, iterator);
    }

    public SummaryWriter summaryWriter(SummaryWriter.Options ... options) {
        return SummaryWriter.create(this.scope, options);
    }

    public TensorSummary tensorSummary(Operand<TString> tag, Operand<? extends TType> tensor, Operand<TString> serializedSummaryMetadata) {
        return TensorSummary.create(this.scope, tag, tensor, serializedSummaryMetadata);
    }

    public WriteAudioSummary writeAudioSummary(Operand<? extends TType> writer, Operand<TInt64> step, Operand<TString> tag, Operand<TFloat32> tensor, Operand<TFloat32> sampleRate, WriteAudioSummary.Options ... options) {
        return WriteAudioSummary.create(this.scope, writer, step, tag, tensor, sampleRate, options);
    }

    public WriteGraphSummary writeGraphSummary(Operand<? extends TType> writer, Operand<TInt64> step, Operand<TString> tensor) {
        return WriteGraphSummary.create(this.scope, writer, step, tensor);
    }

    public WriteHistogramSummary writeHistogramSummary(Operand<? extends TType> writer, Operand<TInt64> step, Operand<TString> tag, Operand<? extends TType> values) {
        return WriteHistogramSummary.create(this.scope, writer, step, tag, values);
    }

    public WriteImageSummary writeImageSummary(Operand<? extends TType> writer, Operand<TInt64> step, Operand<TString> tag, Operand<? extends TNumber> tensor, Operand<TUint8> badColor, WriteImageSummary.Options ... options) {
        return WriteImageSummary.create(this.scope, writer, step, tag, tensor, badColor, options);
    }

    public WriteRawProtoSummary writeRawProtoSummary(Operand<? extends TType> writer, Operand<TInt64> step, Operand<TString> tensor) {
        return WriteRawProtoSummary.create(this.scope, writer, step, tensor);
    }

    public WriteScalarSummary writeScalarSummary(Operand<? extends TType> writer, Operand<TInt64> step, Operand<TString> tag, Operand<? extends TNumber> value) {
        return WriteScalarSummary.create(this.scope, writer, step, tag, value);
    }

    public WriteSummary writeSummary(Operand<? extends TType> writer, Operand<TInt64> step, Operand<? extends TType> tensor, Operand<TString> tag, Operand<TString> summaryMetadata) {
        return WriteSummary.create(this.scope, writer, step, tensor, tag, summaryMetadata);
    }

    public final Ops ops() {
        return this.ops;
    }
}

