/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorStridedSliceUpdate", inputsClass=Inputs.class)
public final class TensorStridedSliceUpdate<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorStridedSliceUpdate";
    private Output<T> output;

    public TensorStridedSliceUpdate(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TNumber> TensorStridedSliceUpdate<T> create(Scope scope, Operand<T> input, Operand<U> begin, Operand<U> end, Operand<U> strides, Operand<T> value, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(begin.asOutput());
        opBuilder.addInput(end.asOutput());
        opBuilder.addInput(strides.asOutput());
        opBuilder.addInput(value.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.beginMask != null) {
                    opBuilder.setAttr("begin_mask", opts.beginMask);
                }
                if (opts.endMask != null) {
                    opBuilder.setAttr("end_mask", opts.endMask);
                }
                if (opts.ellipsisMask != null) {
                    opBuilder.setAttr("ellipsis_mask", opts.ellipsisMask);
                }
                if (opts.newAxisMask != null) {
                    opBuilder.setAttr("new_axis_mask", opts.newAxisMask);
                }
                if (opts.shrinkAxisMask == null) continue;
                opBuilder.setAttr("shrink_axis_mask", opts.shrinkAxisMask);
            }
        }
        return new TensorStridedSliceUpdate<T>(opBuilder.build());
    }

    public static Options beginMask(Long beginMask) {
        return new Options().beginMask(beginMask);
    }

    public static Options endMask(Long endMask) {
        return new Options().endMask(endMask);
    }

    public static Options ellipsisMask(Long ellipsisMask) {
        return new Options().ellipsisMask(ellipsisMask);
    }

    public static Options newAxisMask(Long newAxisMask) {
        return new Options().newAxisMask(newAxisMask);
    }

    public static Options shrinkAxisMask(Long shrinkAxisMask) {
        return new Options().shrinkAxisMask(shrinkAxisMask);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=TensorStridedSliceUpdate.class)
    public static class Inputs<T extends TType, U extends TNumber>
    extends RawOpInputs<TensorStridedSliceUpdate<T>> {
        public final Operand<T> input;
        public final Operand<U> begin;
        public final Operand<U> end;
        public final Operand<U> strides;
        public final Operand<T> value;
        public final DataType T;
        public final DataType Index;
        public final long beginMask;
        public final long endMask;
        public final long ellipsisMask;
        public final long newAxisMask;
        public final long shrinkAxisMask;

        public Inputs(GraphOperation op) {
            super(new TensorStridedSliceUpdate(op), op, Arrays.asList("T", "Index", "begin_mask", "end_mask", "ellipsis_mask", "new_axis_mask", "shrink_axis_mask"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.begin = op.input(inputIndex++);
            this.end = op.input(inputIndex++);
            this.strides = op.input(inputIndex++);
            this.value = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Index = op.attributes().getAttrType("Index");
            this.beginMask = op.attributes().getAttrInt("begin_mask");
            this.endMask = op.attributes().getAttrInt("end_mask");
            this.ellipsisMask = op.attributes().getAttrInt("ellipsis_mask");
            this.newAxisMask = op.attributes().getAttrInt("new_axis_mask");
            this.shrinkAxisMask = op.attributes().getAttrInt("shrink_axis_mask");
        }
    }

    public static class Options {
        private Long beginMask;
        private Long endMask;
        private Long ellipsisMask;
        private Long newAxisMask;
        private Long shrinkAxisMask;

        private Options() {
        }

        public Options beginMask(Long beginMask) {
            this.beginMask = beginMask;
            return this;
        }

        public Options endMask(Long endMask) {
            this.endMask = endMask;
            return this;
        }

        public Options ellipsisMask(Long ellipsisMask) {
            this.ellipsisMask = ellipsisMask;
            return this;
        }

        public Options newAxisMask(Long newAxisMask) {
            this.newAxisMask = newAxisMask;
            return this;
        }

        public Options shrinkAxisMask(Long shrinkAxisMask) {
            this.shrinkAxisMask = shrinkAxisMask;
            return this;
        }
    }
}

