/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.collective.CollectiveAllToAll;
import org.tensorflow.op.collective.CollectiveAssignGroup;
import org.tensorflow.op.collective.CollectiveBcastRecv;
import org.tensorflow.op.collective.CollectiveBcastSend;
import org.tensorflow.op.collective.CollectiveGather;
import org.tensorflow.op.collective.CollectiveInitializeCommunicator;
import org.tensorflow.op.collective.CollectivePermute;
import org.tensorflow.op.collective.CollectiveReduce;
import org.tensorflow.op.collective.CollectiveReduceScatter;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class CollectiveOps {
    private final Scope scope;
    private final Ops ops;

    CollectiveOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <T extends TNumber> CollectiveAllToAll<T> collectiveAllToAll(Operand<T> input, Operand<? extends TType> communicator, Operand<TInt32> groupAssignment, CollectiveAllToAll.Options ... options) {
        return CollectiveAllToAll.create(this.scope, input, communicator, groupAssignment, options);
    }

    public CollectiveAssignGroup collectiveAssignGroup(Operand<TInt32> groupAssignment, Operand<TInt32> deviceIndex, Operand<TInt32> baseKey) {
        return CollectiveAssignGroup.create(this.scope, groupAssignment, deviceIndex, baseKey);
    }

    public <U extends TType> CollectiveBcastRecv<U> collectiveBcastRecv(Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, Operand<? extends TNumber> shape, Class<U> T, CollectiveBcastRecv.Options ... options) {
        return CollectiveBcastRecv.create(this.scope, groupSize, groupKey, instanceKey, shape, T, options);
    }

    public <T extends TType> CollectiveBcastSend<T> collectiveBcastSend(Operand<T> input, Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, CollectiveBcastSend.Options ... options) {
        return CollectiveBcastSend.create(this.scope, input, groupSize, groupKey, instanceKey, options);
    }

    public <T extends TNumber> CollectiveGather<T> collectiveGather(Operand<T> input, Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, Iterable<Operand<? extends TType>> orderingToken, CollectiveGather.Options ... options) {
        return CollectiveGather.create(this.scope, input, groupSize, groupKey, instanceKey, orderingToken, options);
    }

    public CollectiveInitializeCommunicator collectiveInitializeCommunicator(Operand<TInt32> groupKey, Operand<TInt32> rank, Operand<TInt32> groupSize, CollectiveInitializeCommunicator.Options ... options) {
        return CollectiveInitializeCommunicator.create(this.scope, groupKey, rank, groupSize, options);
    }

    public <T extends TType> CollectivePermute<T> collectivePermute(Operand<T> input, Operand<TInt32> sourceTargetPairs) {
        return CollectivePermute.create(this.scope, input, sourceTargetPairs);
    }

    public <T extends TNumber> CollectiveReduce<T> collectiveReduce(Operand<T> input, Operand<? extends TType> communicator, Operand<TInt32> groupAssignment, String reduction, CollectiveReduce.Options ... options) {
        return CollectiveReduce.create(this.scope, input, communicator, groupAssignment, reduction, options);
    }

    public <T extends TNumber> CollectiveReduceScatter<T> collectiveReduceScatter(Operand<T> input, Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, Iterable<Operand<? extends TType>> orderingToken, String mergeOp, String finalOp, CollectiveReduceScatter.Options ... options) {
        return CollectiveReduceScatter.create(this.scope, input, groupSize, groupKey, instanceKey, orderingToken, mergeOp, finalOp, options);
    }

    public final Ops ops() {
        return this.ops;
    }
}

