/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.dense;

import org.tensorflow.ndarray.DoubleNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.ndarray.impl.dense.DataTransfer;
import org.tensorflow.ndarray.impl.dense.Validator;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;

public class DoubleDenseNdArray
extends AbstractDenseNdArray<Double, DoubleNdArray>
implements DoubleNdArray {
    private final DoubleDataBuffer buffer;

    public static DoubleNdArray create(DoubleDataBuffer buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new DoubleDenseNdArray(buffer, shape);
    }

    @Override
    public double getDouble(long ... indices) {
        return this.buffer.getDouble(this.positionOf(indices, true));
    }

    @Override
    public DoubleNdArray setDouble(double value, long ... indices) {
        this.buffer.setDouble(value, this.positionOf(indices, true));
        return this;
    }

    @Override
    public DoubleNdArray copyTo(NdArray<Double> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof DoubleDenseNdArray) {
            DoubleDenseNdArray doubleDst = (DoubleDenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), doubleDst.buffer, doubleDst.dimensions(), DataTransfer::ofDouble);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    @Override
    public DoubleNdArray copyTo(DoubleDataBuffer dst) {
        Validator.copyToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer, this.dimensions(), dst, DataTransfer::ofDouble);
        return this;
    }

    @Override
    public DoubleNdArray copyFrom(DoubleDataBuffer src) {
        Validator.copyFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer, this.dimensions(), DataTransfer::ofDouble);
        return this;
    }

    protected DoubleDenseNdArray(DoubleDataBuffer buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    DoubleDenseNdArray instantiateView(DataBuffer<Double> buffer, DimensionalSpace dimensions) {
        return new DoubleDenseNdArray((DoubleDataBuffer)buffer, dimensions);
    }

    protected DoubleDataBuffer buffer() {
        return this.buffer;
    }

    private DoubleDenseNdArray(DoubleDataBuffer buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

