/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseCoreFtrl", inputsClass=Inputs.class)
public final class XlaSparseCoreFtrl
extends RawOp {
    public static final String OP_NAME = "XlaSparseCoreFtrl";
    private Output<TFloat32> updatedEmbeddingTable;
    private Output<TFloat32> updatedAccumulator;
    private Output<TFloat32> updatedLinear;

    public XlaSparseCoreFtrl(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.updatedEmbeddingTable = operation.output(outputIdx++);
        this.updatedAccumulator = operation.output(outputIdx++);
        this.updatedLinear = operation.output(outputIdx++);
    }

    public static XlaSparseCoreFtrl create(Scope scope, Operand<TFloat32> embeddingTable, Operand<TFloat32> accumulator, Operand<TFloat32> linear, Operand<TFloat32> learningRate, Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> beta, Operand<TFloat32> learningRatePower, Operand<TFloat32> l2RegularizationStrength, Long featureWidth, Boolean multiplyLinearByLearningRate, Float l1RegularizationStrength) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.addInput(accumulator.asOutput());
        opBuilder.addInput(linear.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(gradient.asOutput());
        opBuilder.addInput(beta.asOutput());
        opBuilder.addInput(learningRatePower.asOutput());
        opBuilder.addInput(l2RegularizationStrength.asOutput());
        opBuilder.setAttr("feature_width", featureWidth);
        opBuilder.setAttr("multiply_linear_by_learning_rate", multiplyLinearByLearningRate);
        opBuilder.setAttr("l1_regularization_strength", l1RegularizationStrength.floatValue());
        return new XlaSparseCoreFtrl(opBuilder.build());
    }

    public Output<TFloat32> updatedEmbeddingTable() {
        return this.updatedEmbeddingTable;
    }

    public Output<TFloat32> updatedAccumulator() {
        return this.updatedAccumulator;
    }

    public Output<TFloat32> updatedLinear() {
        return this.updatedLinear;
    }

    @OpInputsMetadata(outputsClass=XlaSparseCoreFtrl.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseCoreFtrl> {
        public final Operand<TFloat32> embeddingTable;
        public final Operand<TFloat32> accumulator;
        public final Operand<TFloat32> linear;
        public final Operand<TFloat32> learningRate;
        public final Operand<TInt32> indices;
        public final Operand<TFloat32> gradient;
        public final Operand<TFloat32> beta;
        public final Operand<TFloat32> learningRatePower;
        public final Operand<TFloat32> l2RegularizationStrength;
        public final long featureWidth;
        public final boolean multiplyLinearByLearningRate;
        public final float l1RegularizationStrength;

        public Inputs(GraphOperation op) {
            super(new XlaSparseCoreFtrl(op), op, Arrays.asList("feature_width", "multiply_linear_by_learning_rate", "l1_regularization_strength"));
            int inputIndex = 0;
            this.embeddingTable = op.input(inputIndex++);
            this.accumulator = op.input(inputIndex++);
            this.linear = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.gradient = op.input(inputIndex++);
            this.beta = op.input(inputIndex++);
            this.learningRatePower = op.input(inputIndex++);
            this.l2RegularizationStrength = op.input(inputIndex++);
            this.featureWidth = op.attributes().getAttrInt("feature_width");
            this.multiplyLinearByLearningRate = op.attributes().getAttrBool("multiply_linear_by_learning_rate");
            this.l1RegularizationStrength = op.attributes().getAttrFloat("l1_regularization_strength");
        }
    }
}

