/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="RetrieveAllTPUEmbeddingParameters", inputsClass=Inputs.class)
public final class RetrieveAllTPUEmbeddingParameters
extends RawOp {
    public static final String OP_NAME = "RetrieveAllTPUEmbeddingParameters";
    private List<Output<TFloat32>> parameters;
    private List<Output<TFloat32>> auxiliary1;
    private List<Output<TFloat32>> auxiliary2;
    private List<Output<TFloat32>> auxiliary3;
    private List<Output<TFloat32>> auxiliary4;
    private List<Output<TFloat32>> auxiliary5;
    private List<Output<TFloat32>> auxiliary6;
    private List<Output<TFloat32>> auxiliary7;

    public RetrieveAllTPUEmbeddingParameters(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int parametersLength = operation.outputListLength("parameters");
        this.parameters = Arrays.asList(operation.outputList(outputIdx, parametersLength));
        int auxiliary1Length = operation.outputListLength("auxiliary1");
        this.auxiliary1 = Arrays.asList(operation.outputList(outputIdx += parametersLength, auxiliary1Length));
        int auxiliary2Length = operation.outputListLength("auxiliary2");
        this.auxiliary2 = Arrays.asList(operation.outputList(outputIdx += auxiliary1Length, auxiliary2Length));
        int auxiliary3Length = operation.outputListLength("auxiliary3");
        this.auxiliary3 = Arrays.asList(operation.outputList(outputIdx += auxiliary2Length, auxiliary3Length));
        int auxiliary4Length = operation.outputListLength("auxiliary4");
        this.auxiliary4 = Arrays.asList(operation.outputList(outputIdx += auxiliary3Length, auxiliary4Length));
        int auxiliary5Length = operation.outputListLength("auxiliary5");
        this.auxiliary5 = Arrays.asList(operation.outputList(outputIdx += auxiliary4Length, auxiliary5Length));
        int auxiliary6Length = operation.outputListLength("auxiliary6");
        this.auxiliary6 = Arrays.asList(operation.outputList(outputIdx += auxiliary5Length, auxiliary6Length));
        int auxiliary7Length = operation.outputListLength("auxiliary7");
        this.auxiliary7 = Arrays.asList(operation.outputList(outputIdx += auxiliary6Length, auxiliary7Length));
        outputIdx += auxiliary7Length;
    }

    public static RetrieveAllTPUEmbeddingParameters create(Scope scope, Long NumTables, String config, Long numShards, Long shardId) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("NumTables", NumTables);
        opBuilder.setAttr("config", config);
        opBuilder.setAttr("num_shards", numShards);
        opBuilder.setAttr("shard_id", shardId);
        return new RetrieveAllTPUEmbeddingParameters(opBuilder.build());
    }

    public List<Output<TFloat32>> parameters() {
        return this.parameters;
    }

    public List<Output<TFloat32>> auxiliary1() {
        return this.auxiliary1;
    }

    public List<Output<TFloat32>> auxiliary2() {
        return this.auxiliary2;
    }

    public List<Output<TFloat32>> auxiliary3() {
        return this.auxiliary3;
    }

    public List<Output<TFloat32>> auxiliary4() {
        return this.auxiliary4;
    }

    public List<Output<TFloat32>> auxiliary5() {
        return this.auxiliary5;
    }

    public List<Output<TFloat32>> auxiliary6() {
        return this.auxiliary6;
    }

    public List<Output<TFloat32>> auxiliary7() {
        return this.auxiliary7;
    }

    @OpInputsMetadata(outputsClass=RetrieveAllTPUEmbeddingParameters.class)
    public static class Inputs
    extends RawOpInputs<RetrieveAllTPUEmbeddingParameters> {
        public final String config;
        public final long numShards;
        public final long shardId;

        public Inputs(GraphOperation op) {
            super(new RetrieveAllTPUEmbeddingParameters(op), op, Arrays.asList("config", "num_shards", "shard_id"));
            boolean inputIndex = false;
            this.config = op.attributes().getAttrString("config");
            this.numShards = op.attributes().getAttrInt("num_shards");
            this.shardId = op.attributes().getAttrInt("shard_id");
        }
    }
}

