/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="RegexReplace", inputsClass=Inputs.class)
public final class RegexReplace
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "RegexReplace";
    private Output<TString> output;

    public RegexReplace(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static RegexReplace create(Scope scope, Operand<TString> input, Operand<TString> pattern, Operand<TString> rewrite, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(pattern.asOutput());
        opBuilder.addInput(rewrite.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.replaceGlobal == null) continue;
                opBuilder.setAttr("replace_global", opts.replaceGlobal);
            }
        }
        return new RegexReplace(opBuilder.build());
    }

    public static Options replaceGlobal(Boolean replaceGlobal) {
        return new Options().replaceGlobal(replaceGlobal);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RegexReplace.class)
    public static class Inputs
    extends RawOpInputs<RegexReplace> {
        public final Operand<TString> input;
        public final Operand<TString> pattern;
        public final Operand<TString> rewrite;
        public final boolean replaceGlobal;

        public Inputs(GraphOperation op) {
            super(new RegexReplace(op), op, Arrays.asList("replace_global"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.pattern = op.input(inputIndex++);
            this.rewrite = op.input(inputIndex++);
            this.replaceGlobal = op.attributes().getAttrBool("replace_global");
        }
    }

    public static class Options {
        private Boolean replaceGlobal;

        private Options() {
        }

        public Options replaceGlobal(Boolean replaceGlobal) {
            this.replaceGlobal = replaceGlobal;
            return this;
        }
    }
}

