/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="SparseSoftmax", inputsClass=Inputs.class)
public final class SparseSoftmax<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "SparseSoftmax";
    private Output<T> output;

    public SparseSoftmax(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> SparseSoftmax<T> create(Scope scope, Operand<TInt64> spIndices, Operand<T> spValues, Operand<TInt64> spShape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(spIndices.asOutput());
        opBuilder.addInput(spValues.asOutput());
        opBuilder.addInput(spShape.asOutput());
        return new SparseSoftmax<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SparseSoftmax.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<SparseSoftmax<T>> {
        public final Operand<TInt64> spIndices;
        public final Operand<T> spValues;
        public final Operand<TInt64> spShape;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new SparseSoftmax(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.spIndices = op.input(inputIndex++);
            this.spValues = op.input(inputIndex++);
            this.spShape = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

