/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.dtypes;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="AsString", inputsClass=Inputs.class)
public final class AsString
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "AsString";
    private Output<TString> output;

    public AsString(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static AsString create(Scope scope, Operand<? extends TType> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.precision != null) {
                    opBuilder.setAttr("precision", opts.precision);
                }
                if (opts.scientific != null) {
                    opBuilder.setAttr("scientific", opts.scientific);
                }
                if (opts.shortest != null) {
                    opBuilder.setAttr("shortest", opts.shortest);
                }
                if (opts.width != null) {
                    opBuilder.setAttr("width", opts.width);
                }
                if (opts.fill == null) continue;
                opBuilder.setAttr("fill", opts.fill);
            }
        }
        return new AsString(opBuilder.build());
    }

    public static Options precision(Long precision) {
        return new Options().precision(precision);
    }

    public static Options scientific(Boolean scientific) {
        return new Options().scientific(scientific);
    }

    public static Options shortest(Boolean shortest) {
        return new Options().shortest(shortest);
    }

    public static Options width(Long width) {
        return new Options().width(width);
    }

    public static Options fill(String fill) {
        return new Options().fill(fill);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=AsString.class)
    public static class Inputs
    extends RawOpInputs<AsString> {
        public final Operand<? extends TType> input;
        public final DataType T;
        public final long precision;
        public final boolean scientific;
        public final boolean shortest;
        public final long width;
        public final String fill;

        public Inputs(GraphOperation op) {
            super(new AsString(op), op, Arrays.asList("T", "precision", "scientific", "shortest", "width", "fill"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.precision = op.attributes().getAttrInt("precision");
            this.scientific = op.attributes().getAttrBool("scientific");
            this.shortest = op.attributes().getAttrBool("shortest");
            this.width = op.attributes().getAttrInt("width");
            this.fill = op.attributes().getAttrString("fill");
        }
    }

    public static class Options {
        private Long precision;
        private Boolean scientific;
        private Boolean shortest;
        private Long width;
        private String fill;

        private Options() {
        }

        public Options precision(Long precision) {
            this.precision = precision;
            return this;
        }

        public Options scientific(Boolean scientific) {
            this.scientific = scientific;
            return this;
        }

        public Options shortest(Boolean shortest) {
            this.shortest = shortest;
            return this;
        }

        public Options width(Long width) {
            this.width = width;
            return this;
        }

        public Options fill(String fill) {
            this.fill = fill;
            return this;
        }
    }
}

