/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ConcatOffset", inputsClass=Inputs.class)
public final class ConcatOffset<T extends TNumber>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "ConcatOffset";
    private List<Output<T>> offset;

    public ConcatOffset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int offsetLength = operation.outputListLength("offset");
        this.offset = Arrays.asList(operation.outputList(outputIdx, offsetLength));
        outputIdx += offsetLength;
    }

    public static <T extends TNumber> ConcatOffset<T> create(Scope scope, Operand<TInt32> concatDim, Iterable<Operand<T>> shape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(concatDim.asOutput());
        opBuilder.addInputList(Operands.asOutputs(shape));
        return new ConcatOffset<T>(opBuilder.build());
    }

    public List<Output<T>> offset() {
        return this.offset;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.offset.iterator();
    }

    @OpInputsMetadata(outputsClass=ConcatOffset.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ConcatOffset<T>> {
        public final Operand<TInt32> concatDim;
        public final Iterable<Operand<T>> shape;
        public final DataType shapeType;

        public Inputs(GraphOperation op) {
            super(new ConcatOffset(op), op, Arrays.asList("shape_type"));
            int inputIndex = 0;
            this.concatDim = op.input(inputIndex++);
            int shapeLength = op.inputListLength("shape");
            this.shape = Arrays.asList((Operand[])op.inputList(inputIndex, shapeLength));
            inputIndex += shapeLength;
            this.shapeType = op.attributes().getAttrType("shape_type");
        }
    }
}

