/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.io.DecodeBase64;
import org.tensorflow.op.io.DecodeCompressed;
import org.tensorflow.op.io.DecodeCsv;
import org.tensorflow.op.io.DecodeJsonExample;
import org.tensorflow.op.io.DecodePaddedRaw;
import org.tensorflow.op.io.DecodeRaw;
import org.tensorflow.op.io.DeserializeManySparse;
import org.tensorflow.op.io.DisableCopyOnRead;
import org.tensorflow.op.io.EncodeBase64;
import org.tensorflow.op.io.FakeQueue;
import org.tensorflow.op.io.FifoQueue;
import org.tensorflow.op.io.FixedLengthRecordReader;
import org.tensorflow.op.io.IdentityReader;
import org.tensorflow.op.io.LmdbReader;
import org.tensorflow.op.io.MatchingFiles;
import org.tensorflow.op.io.PaddingFifoQueue;
import org.tensorflow.op.io.ParseExample;
import org.tensorflow.op.io.ParseSequenceExample;
import org.tensorflow.op.io.ParseSingleExample;
import org.tensorflow.op.io.ParseSingleSequenceExample;
import org.tensorflow.op.io.ParseTensor;
import org.tensorflow.op.io.PriorityQueue;
import org.tensorflow.op.io.QueueClose;
import org.tensorflow.op.io.QueueDequeue;
import org.tensorflow.op.io.QueueDequeueMany;
import org.tensorflow.op.io.QueueDequeueUpTo;
import org.tensorflow.op.io.QueueEnqueue;
import org.tensorflow.op.io.QueueEnqueueMany;
import org.tensorflow.op.io.QueueIsClosed;
import org.tensorflow.op.io.QueueSize;
import org.tensorflow.op.io.RandomShuffleQueue;
import org.tensorflow.op.io.ReadFile;
import org.tensorflow.op.io.ReaderNumRecordsProduced;
import org.tensorflow.op.io.ReaderNumWorkUnitsCompleted;
import org.tensorflow.op.io.ReaderRead;
import org.tensorflow.op.io.ReaderReadUpTo;
import org.tensorflow.op.io.ReaderReset;
import org.tensorflow.op.io.ReaderRestoreState;
import org.tensorflow.op.io.ReaderSerializeState;
import org.tensorflow.op.io.SerializeManySparse;
import org.tensorflow.op.io.SerializeSparse;
import org.tensorflow.op.io.SerializeTensor;
import org.tensorflow.op.io.ShardedFilename;
import org.tensorflow.op.io.ShardedFilespec;
import org.tensorflow.op.io.TextLineReader;
import org.tensorflow.op.io.TfRecordReader;
import org.tensorflow.op.io.WholeFileReader;
import org.tensorflow.op.io.WriteFile;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class IoOps {
    private final Scope scope;
    private final Ops ops;

    IoOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public DecodeBase64 decodeBase64(Operand<TString> input) {
        return DecodeBase64.create(this.scope, input);
    }

    public DecodeCompressed decodeCompressed(Operand<TString> bytes, DecodeCompressed.Options ... options) {
        return DecodeCompressed.create(this.scope, bytes, options);
    }

    public DecodeCsv decodeCsv(Operand<TString> records, Iterable<Operand<?>> recordDefaults, DecodeCsv.Options ... options) {
        return DecodeCsv.create(this.scope, records, recordDefaults, options);
    }

    public DecodeJsonExample decodeJsonExample(Operand<TString> jsonExamples) {
        return DecodeJsonExample.create(this.scope, jsonExamples);
    }

    public <T extends TNumber> DecodePaddedRaw<T> decodePaddedRaw(Operand<TString> inputBytes, Operand<TInt32> fixedLength, Class<T> outType, DecodePaddedRaw.Options ... options) {
        return DecodePaddedRaw.create(this.scope, inputBytes, fixedLength, outType, options);
    }

    public <T extends TType> DecodeRaw<T> decodeRaw(Operand<TString> bytes, Class<T> outType, DecodeRaw.Options ... options) {
        return DecodeRaw.create(this.scope, bytes, outType, options);
    }

    public <T extends TType> DeserializeManySparse<T> deserializeManySparse(Operand<TString> serializedSparse, Class<T> dtype) {
        return DeserializeManySparse.create(this.scope, serializedSparse, dtype);
    }

    public DisableCopyOnRead disableCopyOnRead(Operand<? extends TType> resource) {
        return DisableCopyOnRead.create(this.scope, resource);
    }

    public EncodeBase64 encodeBase64(Operand<TString> input, EncodeBase64.Options ... options) {
        return EncodeBase64.create(this.scope, input, options);
    }

    public FakeQueue fakeQueue(Operand<? extends TType> resource) {
        return FakeQueue.create(this.scope, resource);
    }

    public FifoQueue fifoQueue(List<Class<? extends TType>> componentTypes, FifoQueue.Options ... options) {
        return FifoQueue.create(this.scope, componentTypes, options);
    }

    public FixedLengthRecordReader fixedLengthRecordReader(Long recordBytes, FixedLengthRecordReader.Options ... options) {
        return FixedLengthRecordReader.create(this.scope, recordBytes, options);
    }

    public IdentityReader identityReader(IdentityReader.Options ... options) {
        return IdentityReader.create(this.scope, options);
    }

    public LmdbReader lmdbReader(LmdbReader.Options ... options) {
        return LmdbReader.create(this.scope, options);
    }

    public MatchingFiles matchingFiles(Operand<TString> pattern) {
        return MatchingFiles.create(this.scope, pattern);
    }

    public PaddingFifoQueue paddingFifoQueue(List<Class<? extends TType>> componentTypes, PaddingFifoQueue.Options ... options) {
        return PaddingFifoQueue.create(this.scope, componentTypes, options);
    }

    public ParseExample parseExample(Operand<TString> serialized, Operand<TString> names, Operand<TString> sparseKeys, Operand<TString> denseKeys, Operand<TString> raggedKeys, Iterable<Operand<?>> denseDefaults, Long numSparse, List<Class<? extends TType>> sparseTypes, List<Class<? extends TType>> raggedValueTypes, List<Class<? extends TNumber>> raggedSplitTypes, List<Shape> denseShapes) {
        return ParseExample.create(this.scope, serialized, names, sparseKeys, denseKeys, raggedKeys, denseDefaults, numSparse, sparseTypes, raggedValueTypes, raggedSplitTypes, denseShapes);
    }

    public ParseSequenceExample parseSequenceExample(Operand<TString> serialized, Operand<TString> debugName, Operand<TString> contextSparseKeys, Operand<TString> contextDenseKeys, Operand<TString> contextRaggedKeys, Operand<TString> featureListSparseKeys, Operand<TString> featureListDenseKeys, Operand<TString> featureListRaggedKeys, Operand<TBool> featureListDenseMissingAssumedEmpty, Iterable<Operand<?>> contextDenseDefaults, List<Class<? extends TType>> contextSparseTypes, List<Class<? extends TType>> contextRaggedValueTypes, List<Class<? extends TNumber>> contextRaggedSplitTypes, List<Class<? extends TType>> featureListDenseTypes, List<Class<? extends TType>> featureListSparseTypes, List<Class<? extends TType>> featureListRaggedValueTypes, List<Class<? extends TNumber>> featureListRaggedSplitTypes, ParseSequenceExample.Options ... options) {
        return ParseSequenceExample.create(this.scope, serialized, debugName, contextSparseKeys, contextDenseKeys, contextRaggedKeys, featureListSparseKeys, featureListDenseKeys, featureListRaggedKeys, featureListDenseMissingAssumedEmpty, contextDenseDefaults, contextSparseTypes, contextRaggedValueTypes, contextRaggedSplitTypes, featureListDenseTypes, featureListSparseTypes, featureListRaggedValueTypes, featureListRaggedSplitTypes, options);
    }

    public ParseSingleExample parseSingleExample(Operand<TString> serialized, Iterable<Operand<?>> denseDefaults, Long numSparse, List<String> sparseKeys, List<String> denseKeys, List<Class<? extends TType>> sparseTypes, List<Shape> denseShapes) {
        return ParseSingleExample.create(this.scope, serialized, denseDefaults, numSparse, sparseKeys, denseKeys, sparseTypes, denseShapes);
    }

    public ParseSingleSequenceExample parseSingleSequenceExample(Operand<TString> serialized, Operand<TString> featureListDenseMissingAssumedEmpty, Iterable<Operand<TString>> contextSparseKeys, Iterable<Operand<TString>> contextDenseKeys, Iterable<Operand<TString>> featureListSparseKeys, Iterable<Operand<TString>> featureListDenseKeys, Iterable<Operand<?>> contextDenseDefaults, Operand<TString> debugName, List<Class<? extends TType>> contextSparseTypes, List<Class<? extends TType>> featureListDenseTypes, List<Class<? extends TType>> featureListSparseTypes, ParseSingleSequenceExample.Options ... options) {
        return ParseSingleSequenceExample.create(this.scope, serialized, featureListDenseMissingAssumedEmpty, contextSparseKeys, contextDenseKeys, featureListSparseKeys, featureListDenseKeys, contextDenseDefaults, debugName, contextSparseTypes, featureListDenseTypes, featureListSparseTypes, options);
    }

    public <T extends TType> ParseTensor<T> parseTensor(Operand<TString> serialized, Class<T> outType) {
        return ParseTensor.create(this.scope, serialized, outType);
    }

    public PriorityQueue priorityQueue(List<Class<? extends TType>> componentTypes, List<Shape> shapes, PriorityQueue.Options ... options) {
        return PriorityQueue.create(this.scope, componentTypes, shapes, options);
    }

    public QueueClose queueClose(Operand<? extends TType> handle, QueueClose.Options ... options) {
        return QueueClose.create(this.scope, handle, options);
    }

    public QueueDequeue queueDequeue(Operand<? extends TType> handle, List<Class<? extends TType>> componentTypes, QueueDequeue.Options ... options) {
        return QueueDequeue.create(this.scope, handle, componentTypes, options);
    }

    public QueueDequeueMany queueDequeueMany(Operand<? extends TType> handle, Operand<TInt32> n, List<Class<? extends TType>> componentTypes, QueueDequeueMany.Options ... options) {
        return QueueDequeueMany.create(this.scope, handle, n, componentTypes, options);
    }

    public QueueDequeueUpTo queueDequeueUpTo(Operand<? extends TType> handle, Operand<TInt32> n, List<Class<? extends TType>> componentTypes, QueueDequeueUpTo.Options ... options) {
        return QueueDequeueUpTo.create(this.scope, handle, n, componentTypes, options);
    }

    public QueueEnqueue queueEnqueue(Operand<? extends TType> handle, Iterable<Operand<?>> components, QueueEnqueue.Options ... options) {
        return QueueEnqueue.create(this.scope, handle, components, options);
    }

    public QueueEnqueueMany queueEnqueueMany(Operand<? extends TType> handle, Iterable<Operand<?>> components, QueueEnqueueMany.Options ... options) {
        return QueueEnqueueMany.create(this.scope, handle, components, options);
    }

    public QueueIsClosed queueIsClosed(Operand<? extends TType> handle) {
        return QueueIsClosed.create(this.scope, handle);
    }

    public QueueSize queueSize(Operand<? extends TType> handle) {
        return QueueSize.create(this.scope, handle);
    }

    public RandomShuffleQueue randomShuffleQueue(List<Class<? extends TType>> componentTypes, RandomShuffleQueue.Options ... options) {
        return RandomShuffleQueue.create(this.scope, componentTypes, options);
    }

    public ReadFile readFile(Operand<TString> filename) {
        return ReadFile.create(this.scope, filename);
    }

    public ReaderNumRecordsProduced readerNumRecordsProduced(Operand<? extends TType> readerHandle) {
        return ReaderNumRecordsProduced.create(this.scope, readerHandle);
    }

    public ReaderNumWorkUnitsCompleted readerNumWorkUnitsCompleted(Operand<? extends TType> readerHandle) {
        return ReaderNumWorkUnitsCompleted.create(this.scope, readerHandle);
    }

    public ReaderRead readerRead(Operand<? extends TType> readerHandle, Operand<? extends TType> queueHandle) {
        return ReaderRead.create(this.scope, readerHandle, queueHandle);
    }

    public ReaderReadUpTo readerReadUpTo(Operand<? extends TType> readerHandle, Operand<? extends TType> queueHandle, Operand<TInt64> numRecords) {
        return ReaderReadUpTo.create(this.scope, readerHandle, queueHandle, numRecords);
    }

    public ReaderReset readerReset(Operand<? extends TType> readerHandle) {
        return ReaderReset.create(this.scope, readerHandle);
    }

    public ReaderRestoreState readerRestoreState(Operand<? extends TType> readerHandle, Operand<TString> state) {
        return ReaderRestoreState.create(this.scope, readerHandle, state);
    }

    public ReaderSerializeState readerSerializeState(Operand<? extends TType> readerHandle) {
        return ReaderSerializeState.create(this.scope, readerHandle);
    }

    public SerializeManySparse<TString> serializeManySparse(Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape) {
        return SerializeManySparse.create(this.scope, sparseIndices, sparseValues, sparseShape);
    }

    public <U extends TType> SerializeManySparse<U> serializeManySparse(Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape, Class<U> outType) {
        return SerializeManySparse.create(this.scope, sparseIndices, sparseValues, sparseShape, outType);
    }

    public SerializeSparse<TString> serializeSparse(Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape) {
        return SerializeSparse.create(this.scope, sparseIndices, sparseValues, sparseShape);
    }

    public <U extends TType> SerializeSparse<U> serializeSparse(Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape, Class<U> outType) {
        return SerializeSparse.create(this.scope, sparseIndices, sparseValues, sparseShape, outType);
    }

    public SerializeTensor serializeTensor(Operand<? extends TType> tensor) {
        return SerializeTensor.create(this.scope, tensor);
    }

    public ShardedFilename shardedFilename(Operand<TString> basename, Operand<TInt32> shard, Operand<TInt32> numShards) {
        return ShardedFilename.create(this.scope, basename, shard, numShards);
    }

    public ShardedFilespec shardedFilespec(Operand<TString> basename, Operand<TInt32> numShards) {
        return ShardedFilespec.create(this.scope, basename, numShards);
    }

    public TextLineReader textLineReader(TextLineReader.Options ... options) {
        return TextLineReader.create(this.scope, options);
    }

    public TfRecordReader tfRecordReader(TfRecordReader.Options ... options) {
        return TfRecordReader.create(this.scope, options);
    }

    public WholeFileReader wholeFileReader(WholeFileReader.Options ... options) {
        return WholeFileReader.create(this.scope, options);
    }

    public WriteFile writeFile(Operand<TString> filename, Operand<TString> contents) {
        return WriteFile.create(this.scope, filename, contents);
    }

    public final Ops ops() {
        return this.ops;
    }
}

