/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.adapter;

import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.layout.IntDataLayout;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.adapter.AbstractDataBufferAdapter;

class IntDataBufferAdapter<S extends DataBuffer<?>>
extends AbstractDataBufferAdapter<S, Integer, IntDataBuffer>
implements IntDataBuffer {
    private IntDataLayout<S> layout;

    @Override
    public int getInt(long index) {
        Validator.getArgs(this, index);
        return this.layout.readInt(this.buffer(), index * (long)this.layout.scale());
    }

    @Override
    public IntDataBuffer setInt(int value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeInt(this.buffer(), value, index * (long)this.layout.scale());
        return this;
    }

    @Override
    public IntDataBuffer read(int[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            dst[j] = this.layout.readInt(this.buffer(), i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public IntDataBuffer write(int[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.layout.writeInt(this.buffer(), src[j], i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public IntDataBuffer copyTo(DataBuffer<Integer> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof IntDataBuffer) {
            IntDataBuffer intDst = (IntDataBuffer)dst;
            for (long idx = 0L; idx < size; ++idx) {
                intDst.setInt(this.getInt(idx), idx);
            }
            return this;
        }
        return (IntDataBuffer)this.slowCopyTo(dst, size);
    }

    @Override
    public IntDataBuffer offset(long index) {
        return new IntDataBufferAdapter(this.buffer().offset(index * (long)this.layout.scale()), this.layout);
    }

    @Override
    public IntDataBuffer narrow(long size) {
        return new IntDataBufferAdapter(this.buffer().narrow(size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public IntDataBuffer slice(long index, long size) {
        return new IntDataBufferAdapter(this.buffer().slice(index * (long)this.layout.scale(), size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntDataBuffer)) {
            return super.equals(obj);
        }
        IntDataBuffer other = (IntDataBuffer)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (long idx = 0L; idx < this.size(); ++idx) {
            if (other.getInt(idx) == this.getInt(idx)) continue;
            return false;
        }
        return true;
    }

    IntDataBufferAdapter(S buffer, IntDataLayout<S> layout) {
        super(buffer, layout);
        this.layout = layout;
    }
}

