/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.internal.c_api.TF_Server;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.proto.ServerDef;

public final class Server
implements AutoCloseable {
    private TF_Server nativeHandle;
    private int numJoining;

    public Server(ServerDef serverDef) {
        this.nativeHandle = Server.allocate(serverDef);
    }

    public synchronized void start() {
        Server.start(this.nativeHandle);
    }

    public synchronized void stop() {
        Server.stop(this.nativeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        TF_Server handle = null;
        Server server = this;
        synchronized (server) {
            handle = this.nativeHandle;
            if (handle != null && !handle.isNull()) {
                ++this.numJoining;
            }
        }
        try {
            Server.join(handle);
        }
        finally {
            server = this;
            synchronized (server) {
                if (handle != null && !handle.isNull()) {
                    --this.numJoining;
                }
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void close() throws InterruptedException {
        this.stop();
        while (this.numJoining > 0) {
            this.wait();
        }
        Server.delete(this.nativeHandle);
        this.nativeHandle = null;
    }

    private static void requireHandle(TF_Server handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Server");
        }
    }

    private static TF_Server allocate(ServerDef serverDef) {
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            BytePointer serverDefBytes = new BytePointer(serverDef.toByteArray());
            TF_Server server = tensorflow.TF_NewServer((Pointer)serverDefBytes, serverDefBytes.capacity(), status);
            status.throwExceptionIfNotOK();
            TF_Server tF_Server = server;
            return tF_Server;
        }
    }

    private static void start(TF_Server nativeHandle) {
        Server.requireHandle(nativeHandle);
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_ServerStart(nativeHandle, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void stop(TF_Server nativeHandle) {
        Server.requireHandle(nativeHandle);
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_ServerStop(nativeHandle, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void join(TF_Server nativeHandle) {
        Server.requireHandle(nativeHandle);
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_ServerJoin(nativeHandle, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void delete(TF_Server nativeHandle) {
        Server.requireHandle(nativeHandle);
        tensorflow.TF_DeleteServer(nativeHandle);
    }

    static {
        try {
            Class.forName("org.tensorflow.TensorFlow");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

