/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.SparseTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TFloat64Mapper;
import org.tensorflow.ndarray.DoubleNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TFloating;

@TensorType(dataType=DataType.DT_DOUBLE, byteSize=8, mapperClass=TFloat64Mapper.class)
public interface TFloat64
extends DoubleNdArray,
TFloating {
    public static TFloat64 scalarOf(double value) {
        return Tensor.of(TFloat64.class, Shape.scalar(), (T data) -> data.setDouble(value, new long[0]));
    }

    public static TFloat64 vectorOf(double ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(TFloat64.class, Shape.of(values.length), (T data) -> StdArrays.copyTo(values, (DoubleNdArray)data));
    }

    public static TFloat64 tensorOf(NdArray<Double> src) {
        return Tensor.of(TFloat64.class, src.shape(), src::copyTo);
    }

    public static TFloat64 tensorOf(Shape shape) {
        return Tensor.of(TFloat64.class, shape);
    }

    public static TFloat64 tensorOf(Shape shape, DoubleDataBuffer data) {
        return Tensor.of(TFloat64.class, shape, (T d) -> d.copyFrom(data));
    }

    public static TFloat64 tensorOf(Shape shape, Consumer<TFloat64> dataInit) {
        return Tensor.of(TFloat64.class, shape, dataInit);
    }

    public static TFloat64 sparseTensorOf(TInt64 indices, TFloat64 values, TInt64 denseShape) {
        return SparseTensor.of(indices, values, denseShape).asTypedTensor();
    }
}

