/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseCoreSgd", inputsClass=Inputs.class)
public final class XlaSparseCoreSgd
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "XlaSparseCoreSgd";
    private Output<TFloat32> updatedEmbeddingTable;

    public XlaSparseCoreSgd(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.updatedEmbeddingTable = operation.output(outputIdx++);
    }

    public static XlaSparseCoreSgd create(Scope scope, Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Long featureWidth) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(gradient.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.setAttr("feature_width", featureWidth);
        return new XlaSparseCoreSgd(opBuilder.build());
    }

    public Output<TFloat32> updatedEmbeddingTable() {
        return this.updatedEmbeddingTable;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.updatedEmbeddingTable;
    }

    @OpInputsMetadata(outputsClass=XlaSparseCoreSgd.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseCoreSgd> {
        public final Operand<TInt32> indices;
        public final Operand<TFloat32> gradient;
        public final Operand<TFloat32> learningRate;
        public final Operand<TFloat32> embeddingTable;
        public final long featureWidth;

        public Inputs(GraphOperation op) {
            super(new XlaSparseCoreSgd(op), op, Arrays.asList("feature_width"));
            int inputIndex = 0;
            this.indices = op.input(inputIndex++);
            this.gradient = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.embeddingTable = op.input(inputIndex++);
            this.featureWidth = op.attributes().getAttrInt("feature_width");
        }
    }
}

