/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="AllToAll", inputsClass=Inputs.class)
public final class AllToAll<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "AllToAll";
    private Output<T> output;

    public AllToAll(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> AllToAll<T> create(Scope scope, Operand<T> input, Operand<TInt32> groupAssignment, Long concatDimension, Long splitDimension, Long splitCount) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(groupAssignment.asOutput());
        opBuilder.setAttr("concat_dimension", concatDimension);
        opBuilder.setAttr("split_dimension", splitDimension);
        opBuilder.setAttr("split_count", splitCount);
        return new AllToAll<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=AllToAll.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<AllToAll<T>> {
        public final Operand<T> input;
        public final Operand<TInt32> groupAssignment;
        public final DataType T;
        public final long concatDimension;
        public final long splitDimension;
        public final long splitCount;

        public Inputs(GraphOperation op) {
            super(new AllToAll(op), op, Arrays.asList("T", "concat_dimension", "split_dimension", "split_count"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.groupAssignment = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.concatDimension = op.attributes().getAttrInt("concat_dimension");
            this.splitDimension = op.attributes().getAttrInt("split_dimension");
            this.splitCount = op.attributes().getAttrInt("split_count");
        }
    }
}

