/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedRelu6", inputsClass=Inputs.class)
public final class QuantizedRelu6<U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedRelu6";
    private Output<U> activations;
    private Output<TFloat32> minActivations;
    private Output<TFloat32> maxActivations;

    public QuantizedRelu6(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
        this.minActivations = operation.output(outputIdx++);
        this.maxActivations = operation.output(outputIdx++);
    }

    public static <U extends TNumber> QuantizedRelu6<U> create(Scope scope, Operand<? extends TNumber> features, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, Class<U> outType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(features.asOutput());
        opBuilder.addInput(minFeatures.asOutput());
        opBuilder.addInput(maxFeatures.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        return new QuantizedRelu6<U>(opBuilder.build());
    }

    public Output<U> activations() {
        return this.activations;
    }

    public Output<TFloat32> minActivations() {
        return this.minActivations;
    }

    public Output<TFloat32> maxActivations() {
        return this.maxActivations;
    }

    @OpInputsMetadata(outputsClass=QuantizedRelu6.class)
    public static class Inputs
    extends RawOpInputs<QuantizedRelu6<?>> {
        public final Operand<? extends TNumber> features;
        public final Operand<TFloat32> minFeatures;
        public final Operand<TFloat32> maxFeatures;
        public final DataType Tinput;
        public final DataType outType;

        public Inputs(GraphOperation op) {
            super(new QuantizedRelu6(op), op, Arrays.asList("Tinput", "out_type"));
            int inputIndex = 0;
            this.features = op.input(inputIndex++);
            this.minFeatures = op.input(inputIndex++);
            this.maxFeatures = op.input(inputIndex++);
            this.Tinput = op.attributes().getAttrType("Tinput");
            this.outType = op.attributes().getAttrType("out_type");
        }
    }
}

