/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedMaxPool", inputsClass=Inputs.class)
public final class QuantizedMaxPool<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedMaxPool";
    private Output<T> output;
    private Output<TFloat32> minOutput;
    private Output<TFloat32> maxOutput;

    public QuantizedMaxPool(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOutput = operation.output(outputIdx++);
        this.maxOutput = operation.output(outputIdx++);
    }

    public static <T extends TNumber> QuantizedMaxPool<T> create(Scope scope, Operand<T> input, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        return new QuantizedMaxPool<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<TFloat32> minOutput() {
        return this.minOutput;
    }

    public Output<TFloat32> maxOutput() {
        return this.maxOutput;
    }

    @OpInputsMetadata(outputsClass=QuantizedMaxPool.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<QuantizedMaxPool<T>> {
        public final Operand<T> input;
        public final Operand<TFloat32> minInput;
        public final Operand<TFloat32> maxInput;
        public final DataType T;
        public final long[] ksize;
        public final long[] strides;
        public final String padding;

        public Inputs(GraphOperation op) {
            super(new QuantizedMaxPool(op), op, Arrays.asList("T", "ksize", "strides", "padding"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.minInput = op.input(inputIndex++);
            this.maxInput = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.ksize = op.attributes().getAttrIntList("ksize");
            this.strides = op.attributes().getAttrIntList("strides");
            this.padding = op.attributes().getAttrString("padding");
        }
    }
}

