/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListConcatV2", inputsClass=Inputs.class)
public final class TensorListConcat<U extends TType>
extends RawOp {
    public static final String OP_NAME = "TensorListConcatV2";
    private Output<U> tensor;
    private Output<TInt64> lengths;

    public TensorListConcat(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
        this.lengths = operation.output(outputIdx++);
    }

    public static <U extends TType> TensorListConcat<U> create(Scope scope, Operand<? extends TType> inputHandle, Operand<? extends TNumber> elementShape, Operand<TInt64> leadingDims, Class<U> elementDtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TensorListConcat");
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        opBuilder.addInput(leadingDims.asOutput());
        opBuilder.setAttr("element_dtype", Operands.toDataType(elementDtype));
        return new TensorListConcat<U>(opBuilder.build());
    }

    public Output<U> tensor() {
        return this.tensor;
    }

    public Output<TInt64> lengths() {
        return this.lengths;
    }

    @OpInputsMetadata(outputsClass=TensorListConcat.class)
    public static class Inputs
    extends RawOpInputs<TensorListConcat<?>> {
        public final Operand<? extends TType> inputHandle;
        public final Operand<? extends TNumber> elementShape;
        public final Operand<TInt64> leadingDims;
        public final DataType elementDtype;
        public final DataType shapeType;

        public Inputs(GraphOperation op) {
            super(new TensorListConcat(op), op, Arrays.asList("element_dtype", "shape_type"));
            int inputIndex = 0;
            this.inputHandle = op.input(inputIndex++);
            this.elementShape = op.input(inputIndex++);
            this.leadingDims = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
            this.shapeType = op.attributes().getAttrType("shape_type");
        }
    }
}

