/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorArrayReadV3", inputsClass=Inputs.class)
public final class TensorArrayRead<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorArrayReadV3";
    private Output<T> value;

    public TensorArrayRead(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorArrayRead<T> create(Scope scope, Operand<? extends TType> handle, Operand<TInt32> index, Operand<TFloat32> flowIn, Class<T> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TensorArrayRead");
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new TensorArrayRead<T>(opBuilder.build());
    }

    public Output<T> value() {
        return this.value;
    }

    @Override
    public Output<T> asOutput() {
        return this.value;
    }

    @OpInputsMetadata(outputsClass=TensorArrayRead.class)
    public static class Inputs
    extends RawOpInputs<TensorArrayRead<?>> {
        public final Operand<? extends TType> handle;
        public final Operand<TInt32> index;
        public final Operand<TFloat32> flowIn;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new TensorArrayRead(op), op, Arrays.asList("dtype"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.index = op.input(inputIndex++);
            this.flowIn = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }
}

