/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorArrayGradWithShape", inputsClass=Inputs.class)
public final class TensorArrayGradWithShape
extends RawOp {
    public static final String OP_NAME = "TensorArrayGradWithShape";
    private Output<? extends TType> gradHandle;
    private Output<TFloat32> flowOut;

    public TensorArrayGradWithShape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.gradHandle = operation.output(outputIdx++);
        this.flowOut = operation.output(outputIdx++);
    }

    public static TensorArrayGradWithShape create(Scope scope, Operand<? extends TType> handle, Operand<TFloat32> flowIn, Operand<TInt32> shapeToPrepend, String source) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder.addInput(shapeToPrepend.asOutput());
        opBuilder.setAttr("source", source);
        return new TensorArrayGradWithShape(opBuilder.build());
    }

    public Output<? extends TType> gradHandle() {
        return this.gradHandle;
    }

    public Output<TFloat32> flowOut() {
        return this.flowOut;
    }

    @OpInputsMetadata(outputsClass=TensorArrayGradWithShape.class)
    public static class Inputs
    extends RawOpInputs<TensorArrayGradWithShape> {
        public final Operand<? extends TType> handle;
        public final Operand<TFloat32> flowIn;
        public final Operand<TInt32> shapeToPrepend;
        public final String source;

        public Inputs(GraphOperation op) {
            super(new TensorArrayGradWithShape(op), op, Arrays.asList("source"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.flowIn = op.input(inputIndex++);
            this.shapeToPrepend = op.input(inputIndex++);
            this.source = op.attributes().getAttrString("source");
        }
    }
}

