/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.impl.dense.LongDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.LongSparseNdArray;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;

public final class TInt64Mapper
extends TensorMapper<TInt64> {
    @Override
    protected TInt64 mapDense(RawTensor tensor) {
        LongDataBuffer buffer = TensorBuffers.toLongs(TInt64Mapper.nativeHandle(tensor));
        return new DenseTInt64(tensor, buffer);
    }

    @Override
    protected SparseTensor<TInt64> mapSparse(TInt64 indices, TInt64 values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTInt64(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTInt64
    extends LongSparseNdArray
    implements TInt64,
    SparseTensor<TInt64> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TInt64> type() {
            return TInt64.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TInt64 values() {
            return (TInt64)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTInt64(TInt64 indices, TInt64 values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, 0L, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTInt64
    extends LongDenseNdArray
    implements TInt64 {
        final RawTensor rawTensor;

        public Class<TInt64> type() {
            return TInt64.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTInt64(RawTensor rawTensor, LongDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

