/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.buffer;

import org.bytedeco.javacpp.Pointer;
import org.tensorflow.internal.buffer.ByteSequenceTensorBuffer;
import org.tensorflow.internal.buffer.TensorRawDataBufferFactory;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;

public final class TensorBuffers {
    public static ByteDataBuffer toBytes(TF_Tensor nativeTensor) {
        return TensorBuffers.toBytes(nativeTensor, false);
    }

    public static ByteDataBuffer toBytes(TF_Tensor nativeTensor, boolean readOnly) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToBytes(tensorMemory, readOnly);
        }
        return DataBuffers.of(tensorMemory.asByteBuffer().asReadOnlyBuffer());
    }

    public static IntDataBuffer toInts(TF_Tensor nativeTensor) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToInts(tensorMemory);
        }
        return DataBuffers.of(tensorMemory.asByteBuffer().asIntBuffer());
    }

    public static LongDataBuffer toLongs(TF_Tensor nativeTensor) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToLongs(tensorMemory);
        }
        return DataBuffers.of(tensorMemory.asByteBuffer().asLongBuffer());
    }

    public static FloatDataBuffer toFloats(TF_Tensor nativeTensor) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToFloats(tensorMemory);
        }
        return DataBuffers.of(tensorMemory.asByteBuffer().asFloatBuffer());
    }

    public static DoubleDataBuffer toDoubles(TF_Tensor nativeTensor) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToDoubles(tensorMemory);
        }
        return DataBuffers.of(tensorMemory.asByteBuffer().asDoubleBuffer());
    }

    public static ShortDataBuffer toShorts(TF_Tensor nativeTensor) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToShorts(tensorMemory);
        }
        return DataBuffers.of(tensorMemory.asByteBuffer().asShortBuffer());
    }

    public static BooleanDataBuffer toBooleans(TF_Tensor nativeTensor) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToBooleans(tensorMemory);
        }
        return DataLayouts.BOOL.applyTo((DataBuffer)DataBuffers.of(tensorMemory.asByteBuffer()));
    }

    public static ByteSequenceTensorBuffer toStrings(TF_Tensor nativeTensor, long numElements) {
        Pointer tensorMemory = TensorBuffers.tensorMemory(nativeTensor);
        if (TensorRawDataBufferFactory.canBeUsed()) {
            return TensorRawDataBufferFactory.mapTensorToStrings(tensorMemory, numElements);
        }
        if (numElements > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot map string tensor of " + numElements + " elements");
        }
        return new ByteSequenceTensorBuffer(tensorMemory, numElements);
    }

    private static Pointer tensorMemory(TF_Tensor nativeTensor) {
        return tensorflow.TF_TensorData(nativeTensor).capacity(tensorflow.TF_TensorByteSize(nativeTensor));
    }
}

