/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.tensorflow.SparseTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TStringInitializer;
import org.tensorflow.internal.types.TStringMapper;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TType;

@TensorType(dataType=DataType.DT_STRING, byteSize=-1, mapperClass=TStringMapper.class)
public interface TString
extends NdArray<String>,
TType {
    public static TString scalarOf(String value) {
        return TString.tensorOf(NdArrays.scalarOfObject(value));
    }

    public static TString vectorOf(String ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return TString.tensorOf(NdArrays.vectorOfObjects(values));
    }

    public static TString tensorOf(NdArray<String> src) {
        return TString.tensorOf(StandardCharsets.UTF_8, src);
    }

    public static TString tensorOf(Charset charset, NdArray<String> src) {
        TStringInitializer<String> initializer = new TStringInitializer<String>(src, s -> s.getBytes(charset));
        return Tensor.of(TString.class, src.shape(), initializer.computeRequiredSize(), initializer);
    }

    public static TString tensorOf(Shape shape, DataBuffer<String> data) {
        return TString.tensorOf(NdArrays.wrap(shape, data));
    }

    public static TString tensorOf(Charset charset, Shape shape, DataBuffer<String> data) {
        return TString.tensorOf(charset, NdArrays.wrap(shape, data));
    }

    public static TString tensorOfBytes(NdArray<byte[]> src) {
        TStringInitializer<byte[]> initializer = new TStringInitializer<byte[]>(src, Function.identity());
        return Tensor.of(TString.class, src.shape(), initializer.computeRequiredSize(), initializer);
    }

    public static TString tensorOfBytes(Shape shape, DataBuffer<byte[]> data) {
        return TString.tensorOfBytes(NdArrays.wrap(shape, data));
    }

    public static TString sparseTensorOf(TInt64 indices, TString values, TInt64 denseShape) {
        return SparseTensor.of(indices, values, denseShape).asTypedTensor();
    }

    public TString using(Charset var1);

    public NdArray<byte[]> asBytes();
}

