/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseCoreAdam", inputsClass=Inputs.class)
public final class XlaSparseCoreAdam
extends RawOp {
    public static final String OP_NAME = "XlaSparseCoreAdam";
    private Output<TFloat32> updatedEmbeddingTable;
    private Output<TFloat32> updatedVelocity;
    private Output<TFloat32> updatedMomentum;

    public XlaSparseCoreAdam(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.updatedEmbeddingTable = operation.output(outputIdx++);
        this.updatedVelocity = operation.output(outputIdx++);
        this.updatedMomentum = operation.output(outputIdx++);
    }

    public static XlaSparseCoreAdam create(Scope scope, Operand<TFloat32> embeddingTable, Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> learningRate, Operand<TFloat32> momentum, Operand<TFloat32> velocity, Operand<TFloat32> beta1, Operand<TFloat32> beta2, Operand<TFloat32> epsilon, Long featureWidth, Boolean useSumInsideSqrt) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(gradient.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(momentum.asOutput());
        opBuilder.addInput(velocity.asOutput());
        opBuilder.addInput(beta1.asOutput());
        opBuilder.addInput(beta2.asOutput());
        opBuilder.addInput(epsilon.asOutput());
        opBuilder.setAttr("feature_width", featureWidth);
        opBuilder.setAttr("use_sum_inside_sqrt", useSumInsideSqrt);
        return new XlaSparseCoreAdam(opBuilder.build());
    }

    public Output<TFloat32> updatedEmbeddingTable() {
        return this.updatedEmbeddingTable;
    }

    public Output<TFloat32> updatedVelocity() {
        return this.updatedVelocity;
    }

    public Output<TFloat32> updatedMomentum() {
        return this.updatedMomentum;
    }

    @OpInputsMetadata(outputsClass=XlaSparseCoreAdam.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseCoreAdam> {
        public final Operand<TFloat32> embeddingTable;
        public final Operand<TInt32> indices;
        public final Operand<TFloat32> gradient;
        public final Operand<TFloat32> learningRate;
        public final Operand<TFloat32> momentum;
        public final Operand<TFloat32> velocity;
        public final Operand<TFloat32> beta1;
        public final Operand<TFloat32> beta2;
        public final Operand<TFloat32> epsilon;
        public final long featureWidth;
        public final boolean useSumInsideSqrt;

        public Inputs(GraphOperation op) {
            super(new XlaSparseCoreAdam(op), op, Arrays.asList("feature_width", "use_sum_inside_sqrt"));
            int inputIndex = 0;
            this.embeddingTable = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.gradient = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.momentum = op.input(inputIndex++);
            this.velocity = op.input(inputIndex++);
            this.beta1 = op.input(inputIndex++);
            this.beta2 = op.input(inputIndex++);
            this.epsilon = op.input(inputIndex++);
            this.featureWidth = op.attributes().getAttrInt("feature_width");
            this.useSumInsideSqrt = op.attributes().getAttrBool("use_sum_inside_sqrt");
        }
    }
}

