/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="TopKV2", inputsClass=Inputs.class)
public final class TopK<T extends TNumber, V extends TNumber>
extends RawOp {
    public static final String OP_NAME = "TopKV2";
    private Output<T> values;
    private Output<V> indices;

    public TopK(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.values = operation.output(outputIdx++);
        this.indices = operation.output(outputIdx++);
    }

    public static <T extends TNumber, V extends TNumber> TopK<T, V> create(Scope scope, Operand<T> input, Operand<? extends TNumber> k, Class<V> indexType, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TopK");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(k.asOutput());
        opBuilder.setAttr("index_type", Operands.toDataType(indexType));
        if (options != null) {
            for (Options opts : options) {
                if (opts.sorted == null) continue;
                opBuilder.setAttr("sorted", opts.sorted);
            }
        }
        return new TopK<T, V>(opBuilder.build());
    }

    public static <T extends TNumber> TopK<T, TInt32> create(Scope scope, Operand<T> input, Operand<? extends TNumber> k, Options[] options) {
        return TopK.create(scope, input, k, TInt32.class, options);
    }

    public static Options sorted(Boolean sorted) {
        return new Options().sorted(sorted);
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<V> indices() {
        return this.indices;
    }

    @OpInputsMetadata(outputsClass=TopK.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<TopK<T, ?>> {
        public final Operand<T> input;
        public final Operand<? extends TNumber> k;
        public final boolean sorted;
        public final DataType T;
        public final DataType Tk;
        public final DataType indexType;

        public Inputs(GraphOperation op) {
            super(new TopK(op), op, Arrays.asList("sorted", "T", "Tk", "index_type"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.k = op.input(inputIndex++);
            this.sorted = op.attributes().getAttrBool("sorted");
            this.T = op.attributes().getAttrType("T");
            this.Tk = op.attributes().getAttrType("Tk");
            this.indexType = op.attributes().getAttrType("index_type");
        }
    }

    public static class Options {
        private Boolean sorted;

        private Options() {
        }

        public Options sorted(Boolean sorted) {
            this.sorted = sorted;
            return this;
        }
    }
}

