/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="LRNGrad", inputsClass=Inputs.class)
public final class LocalResponseNormalizationGrad<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "LRNGrad";
    private Output<T> output;

    public LocalResponseNormalizationGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> LocalResponseNormalizationGrad<T> create(Scope scope, Operand<T> inputGrads, Operand<T> inputImage, Operand<T> outputImage, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "LocalResponseNormalizationGrad");
        opBuilder.addInput(inputGrads.asOutput());
        opBuilder.addInput(inputImage.asOutput());
        opBuilder.addInput(outputImage.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.depthRadius != null) {
                    opBuilder.setAttr("depth_radius", opts.depthRadius);
                }
                if (opts.bias != null) {
                    opBuilder.setAttr("bias", opts.bias.floatValue());
                }
                if (opts.alpha != null) {
                    opBuilder.setAttr("alpha", opts.alpha.floatValue());
                }
                if (opts.beta == null) continue;
                opBuilder.setAttr("beta", opts.beta.floatValue());
            }
        }
        return new LocalResponseNormalizationGrad<T>(opBuilder.build());
    }

    public static Options depthRadius(Long depthRadius) {
        return new Options().depthRadius(depthRadius);
    }

    public static Options bias(Float bias) {
        return new Options().bias(bias);
    }

    public static Options alpha(Float alpha) {
        return new Options().alpha(alpha);
    }

    public static Options beta(Float beta) {
        return new Options().beta(beta);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=LocalResponseNormalizationGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<LocalResponseNormalizationGrad<T>> {
        public final Operand<T> inputGrads;
        public final Operand<T> inputImage;
        public final Operand<T> outputImage;
        public final long depthRadius;
        public final float bias;
        public final float alpha;
        public final float beta;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new LocalResponseNormalizationGrad(op), op, Arrays.asList("depth_radius", "bias", "alpha", "beta", "T"));
            int inputIndex = 0;
            this.inputGrads = op.input(inputIndex++);
            this.inputImage = op.input(inputIndex++);
            this.outputImage = op.input(inputIndex++);
            this.depthRadius = op.attributes().getAttrInt("depth_radius");
            this.bias = op.attributes().getAttrFloat("bias");
            this.alpha = op.attributes().getAttrFloat("alpha");
            this.beta = op.attributes().getAttrFloat("beta");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Long depthRadius;
        private Float bias;
        private Float alpha;
        private Float beta;

        private Options() {
        }

        public Options depthRadius(Long depthRadius) {
            this.depthRadius = depthRadius;
            return this;
        }

        public Options bias(Float bias) {
            this.bias = bias;
            return this;
        }

        public Options alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Options beta(Float beta) {
            this.beta = beta;
            return this;
        }
    }
}

