/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="FusedBatchNormV3", inputsClass=Inputs.class)
public final class FusedBatchNorm<T extends TNumber, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "FusedBatchNormV3";
    private Output<T> y;
    private Output<U> batchMean;
    private Output<U> batchVariance;
    private Output<U> reserveSpace1;
    private Output<U> reserveSpace2;
    private Output<U> reserveSpace3;

    public FusedBatchNorm(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.y = operation.output(outputIdx++);
        this.batchMean = operation.output(outputIdx++);
        this.batchVariance = operation.output(outputIdx++);
        this.reserveSpace1 = operation.output(outputIdx++);
        this.reserveSpace2 = operation.output(outputIdx++);
        this.reserveSpace3 = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TNumber> FusedBatchNorm<T, U> create(Scope scope, Operand<T> x, Operand<U> scale, Operand<U> offset, Operand<U> mean, Operand<U> variance, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "FusedBatchNorm");
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(offset.asOutput());
        opBuilder.addInput(mean.asOutput());
        opBuilder.addInput(variance.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.epsilon != null) {
                    opBuilder.setAttr("epsilon", opts.epsilon.floatValue());
                }
                if (opts.exponentialAvgFactor != null) {
                    opBuilder.setAttr("exponential_avg_factor", opts.exponentialAvgFactor.floatValue());
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.isTraining == null) continue;
                opBuilder.setAttr("is_training", opts.isTraining);
            }
        }
        return new FusedBatchNorm<T, U>(opBuilder.build());
    }

    public static Options epsilon(Float epsilon) {
        return new Options().epsilon(epsilon);
    }

    public static Options exponentialAvgFactor(Float exponentialAvgFactor) {
        return new Options().exponentialAvgFactor(exponentialAvgFactor);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public Output<T> y() {
        return this.y;
    }

    public Output<U> batchMean() {
        return this.batchMean;
    }

    public Output<U> batchVariance() {
        return this.batchVariance;
    }

    public Output<U> reserveSpace1() {
        return this.reserveSpace1;
    }

    public Output<U> reserveSpace2() {
        return this.reserveSpace2;
    }

    public Output<U> reserveSpace3() {
        return this.reserveSpace3;
    }

    @OpInputsMetadata(outputsClass=FusedBatchNorm.class)
    public static class Inputs<T extends TNumber, U extends TNumber>
    extends RawOpInputs<FusedBatchNorm<T, U>> {
        public final Operand<T> x;
        public final Operand<U> scale;
        public final Operand<U> offset;
        public final Operand<U> mean;
        public final Operand<U> variance;
        public final DataType T;
        public final DataType U;
        public final float epsilon;
        public final float exponentialAvgFactor;
        public final String dataFormat;
        public final boolean isTraining;

        public Inputs(GraphOperation op) {
            super(new FusedBatchNorm(op), op, Arrays.asList("T", "U", "epsilon", "exponential_avg_factor", "data_format", "is_training"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.scale = op.input(inputIndex++);
            this.offset = op.input(inputIndex++);
            this.mean = op.input(inputIndex++);
            this.variance = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.U = op.attributes().getAttrType("U");
            this.epsilon = op.attributes().getAttrFloat("epsilon");
            this.exponentialAvgFactor = op.attributes().getAttrFloat("exponential_avg_factor");
            this.dataFormat = op.attributes().getAttrString("data_format");
            this.isTraining = op.attributes().getAttrBool("is_training");
        }
    }

    public static class Options {
        private Float epsilon;
        private Float exponentialAvgFactor;
        private String dataFormat;
        private Boolean isTraining;

        private Options() {
        }

        public Options epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Options exponentialAvgFactor(Float exponentialAvgFactor) {
            this.exponentialAvgFactor = exponentialAvgFactor;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }
    }
}

