/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.math;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RequantizationRangePerChannel", inputsClass=Inputs.class)
public final class RequantizationRangePerChannel
extends RawOp {
    public static final String OP_NAME = "RequantizationRangePerChannel";
    private Output<TFloat32> outputMin;
    private Output<TFloat32> outputMax;

    public RequantizationRangePerChannel(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }

    public static RequantizationRangePerChannel create(Scope scope, Operand<? extends TNumber> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax, Float clipValueMax) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        opBuilder.setAttr("clip_value_max", clipValueMax.floatValue());
        return new RequantizationRangePerChannel(opBuilder.build());
    }

    public Output<TFloat32> outputMin() {
        return this.outputMin;
    }

    public Output<TFloat32> outputMax() {
        return this.outputMax;
    }

    @OpInputsMetadata(outputsClass=RequantizationRangePerChannel.class)
    public static class Inputs
    extends RawOpInputs<RequantizationRangePerChannel> {
        public final Operand<? extends TNumber> input;
        public final Operand<TFloat32> inputMin;
        public final Operand<TFloat32> inputMax;
        public final DataType T;
        public final float clipValueMax;

        public Inputs(GraphOperation op) {
            super(new RequantizationRangePerChannel(op), op, Arrays.asList("T", "clip_value_max"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.inputMin = op.input(inputIndex++);
            this.inputMax = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.clipValueMax = op.attributes().getAttrFloat("clip_value_max");
        }
    }
}

