/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TextLineReaderV2", inputsClass=Inputs.class)
public final class TextLineReader
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TextLineReaderV2";
    private Output<? extends TType> readerHandle;

    public TextLineReader(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.readerHandle = operation.output(outputIdx++);
    }

    public static TextLineReader create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TextLineReader");
        if (options != null) {
            for (Options opts : options) {
                if (opts.skipHeaderLines != null) {
                    opBuilder.setAttr("skip_header_lines", opts.skipHeaderLines);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new TextLineReader(opBuilder.build());
    }

    public static Options skipHeaderLines(Long skipHeaderLines) {
        return new Options().skipHeaderLines(skipHeaderLines);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<? extends TType> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.readerHandle;
    }

    @OpInputsMetadata(outputsClass=TextLineReader.class)
    public static class Inputs
    extends RawOpInputs<TextLineReader> {
        public final long skipHeaderLines;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new TextLineReader(op), op, Arrays.asList("skip_header_lines", "container", "shared_name"));
            boolean inputIndex = false;
            this.skipHeaderLines = op.attributes().getAttrInt("skip_header_lines");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private Long skipHeaderLines;
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options skipHeaderLines(Long skipHeaderLines) {
            this.skipHeaderLines = skipHeaderLines;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

