/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;

@OpMetadata(opType="DecodeAndCropJpeg", inputsClass=Inputs.class)
public final class DecodeAndCropJpeg
extends RawOp
implements Operand<TUint8> {
    public static final String OP_NAME = "DecodeAndCropJpeg";
    private Output<TUint8> image;

    public DecodeAndCropJpeg(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.image = operation.output(outputIdx++);
    }

    public static DecodeAndCropJpeg create(Scope scope, Operand<TString> contents, Operand<TInt32> cropWindow, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(contents.asOutput());
        opBuilder.addInput(cropWindow.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.channels != null) {
                    opBuilder.setAttr("channels", opts.channels);
                }
                if (opts.ratio != null) {
                    opBuilder.setAttr("ratio", opts.ratio);
                }
                if (opts.fancyUpscaling != null) {
                    opBuilder.setAttr("fancy_upscaling", opts.fancyUpscaling);
                }
                if (opts.tryRecoverTruncated != null) {
                    opBuilder.setAttr("try_recover_truncated", opts.tryRecoverTruncated);
                }
                if (opts.acceptableFraction != null) {
                    opBuilder.setAttr("acceptable_fraction", opts.acceptableFraction.floatValue());
                }
                if (opts.dctMethod == null) continue;
                opBuilder.setAttr("dct_method", opts.dctMethod);
            }
        }
        return new DecodeAndCropJpeg(opBuilder.build());
    }

    public static Options channels(Long channels) {
        return new Options().channels(channels);
    }

    public static Options ratio(Long ratio) {
        return new Options().ratio(ratio);
    }

    public static Options fancyUpscaling(Boolean fancyUpscaling) {
        return new Options().fancyUpscaling(fancyUpscaling);
    }

    public static Options tryRecoverTruncated(Boolean tryRecoverTruncated) {
        return new Options().tryRecoverTruncated(tryRecoverTruncated);
    }

    public static Options acceptableFraction(Float acceptableFraction) {
        return new Options().acceptableFraction(acceptableFraction);
    }

    public static Options dctMethod(String dctMethod) {
        return new Options().dctMethod(dctMethod);
    }

    public Output<TUint8> image() {
        return this.image;
    }

    @Override
    public Output<TUint8> asOutput() {
        return this.image;
    }

    @OpInputsMetadata(outputsClass=DecodeAndCropJpeg.class)
    public static class Inputs
    extends RawOpInputs<DecodeAndCropJpeg> {
        public final Operand<TString> contents;
        public final Operand<TInt32> cropWindow;
        public final long channels;
        public final long ratio;
        public final boolean fancyUpscaling;
        public final boolean tryRecoverTruncated;
        public final float acceptableFraction;
        public final String dctMethod;

        public Inputs(GraphOperation op) {
            super(new DecodeAndCropJpeg(op), op, Arrays.asList("channels", "ratio", "fancy_upscaling", "try_recover_truncated", "acceptable_fraction", "dct_method"));
            int inputIndex = 0;
            this.contents = op.input(inputIndex++);
            this.cropWindow = op.input(inputIndex++);
            this.channels = op.attributes().getAttrInt("channels");
            this.ratio = op.attributes().getAttrInt("ratio");
            this.fancyUpscaling = op.attributes().getAttrBool("fancy_upscaling");
            this.tryRecoverTruncated = op.attributes().getAttrBool("try_recover_truncated");
            this.acceptableFraction = op.attributes().getAttrFloat("acceptable_fraction");
            this.dctMethod = op.attributes().getAttrString("dct_method");
        }
    }

    public static class Options {
        private Long channels;
        private Long ratio;
        private Boolean fancyUpscaling;
        private Boolean tryRecoverTruncated;
        private Float acceptableFraction;
        private String dctMethod;

        private Options() {
        }

        public Options channels(Long channels) {
            this.channels = channels;
            return this;
        }

        public Options ratio(Long ratio) {
            this.ratio = ratio;
            return this;
        }

        public Options fancyUpscaling(Boolean fancyUpscaling) {
            this.fancyUpscaling = fancyUpscaling;
            return this;
        }

        public Options tryRecoverTruncated(Boolean tryRecoverTruncated) {
            this.tryRecoverTruncated = tryRecoverTruncated;
            return this;
        }

        public Options acceptableFraction(Float acceptableFraction) {
            this.acceptableFraction = acceptableFraction;
            return this;
        }

        public Options dctMethod(String dctMethod) {
            this.dctMethod = dctMethod;
            return this;
        }
    }
}

