/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="CropAndResize", inputsClass=Inputs.class)
public final class CropAndResize
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "CropAndResize";
    private Output<TFloat32> crops;

    public CropAndResize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.crops = operation.output(outputIdx++);
    }

    public static CropAndResize create(Scope scope, Operand<? extends TNumber> image, Operand<TFloat32> boxes, Operand<TInt32> boxInd, Operand<TInt32> cropSize, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(image.asOutput());
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(boxInd.asOutput());
        opBuilder.addInput(cropSize.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.method != null) {
                    opBuilder.setAttr("method", opts.method);
                }
                if (opts.extrapolationValue == null) continue;
                opBuilder.setAttr("extrapolation_value", opts.extrapolationValue.floatValue());
            }
        }
        return new CropAndResize(opBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public static Options extrapolationValue(Float extrapolationValue) {
        return new Options().extrapolationValue(extrapolationValue);
    }

    public Output<TFloat32> crops() {
        return this.crops;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.crops;
    }

    @OpInputsMetadata(outputsClass=CropAndResize.class)
    public static class Inputs
    extends RawOpInputs<CropAndResize> {
        public final Operand<? extends TNumber> image;
        public final Operand<TFloat32> boxes;
        public final Operand<TInt32> boxInd;
        public final Operand<TInt32> cropSize;
        public final DataType T;
        public final String method;
        public final float extrapolationValue;

        public Inputs(GraphOperation op) {
            super(new CropAndResize(op), op, Arrays.asList("T", "method", "extrapolation_value"));
            int inputIndex = 0;
            this.image = op.input(inputIndex++);
            this.boxes = op.input(inputIndex++);
            this.boxInd = op.input(inputIndex++);
            this.cropSize = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.method = op.attributes().getAttrString("method");
            this.extrapolationValue = op.attributes().getAttrFloat("extrapolation_value");
        }
    }

    public static class Options {
        private String method;
        private Float extrapolationValue;

        private Options() {
        }

        public Options method(String method) {
            this.method = method;
            return this;
        }

        public Options extrapolationValue(Float extrapolationValue) {
            this.extrapolationValue = extrapolationValue;
            return this;
        }
    }
}

