/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SaveDatasetV2", inputsClass=Inputs.class)
public final class SaveDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SaveDatasetV2";
    private Output<? extends TType> handle;

    public SaveDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static SaveDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TString> path, Iterable<Operand<?>> shardFuncOtherArgs, ConcreteFunction shardFunc, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SaveDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(path.asOutput());
        opBuilder.addInputList(Operands.asOutputs(shardFuncOtherArgs));
        opBuilder.setAttr("shard_func", shardFunc);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.compression != null) {
                    opBuilder.setAttr("compression", opts.compression);
                }
                if (opts.useShardFunc == null) continue;
                opBuilder.setAttr("use_shard_func", opts.useShardFunc);
            }
        }
        return new SaveDataset(opBuilder.build());
    }

    public static Options compression(String compression) {
        return new Options().compression(compression);
    }

    public static Options useShardFunc(Boolean useShardFunc) {
        return new Options().useShardFunc(useShardFunc);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=SaveDataset.class)
    public static class Inputs
    extends RawOpInputs<SaveDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TString> path;
        public final Iterable<Operand<?>> shardFuncOtherArgs;
        public final String compression;
        public final boolean useShardFunc;
        public final DataType[] TshardFuncArgs;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new SaveDataset(op), op, Arrays.asList("compression", "use_shard_func", "Tshard_func_args", "output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.path = op.input(inputIndex++);
            int shardFuncOtherArgsLength = op.inputListLength("shard_func_other_args");
            this.shardFuncOtherArgs = Arrays.asList((Operand[])op.inputList(inputIndex, shardFuncOtherArgsLength));
            inputIndex += shardFuncOtherArgsLength;
            this.compression = op.attributes().getAttrString("compression");
            this.useShardFunc = op.attributes().getAttrBool("use_shard_func");
            this.TshardFuncArgs = op.attributes().getAttrTypeList("Tshard_func_args");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }

    public static class Options {
        private String compression;
        private Boolean useShardFunc;

        private Options() {
        }

        public Options compression(String compression) {
            this.compression = compression;
            return this;
        }

        public Options useShardFunc(Boolean useShardFunc) {
            this.useShardFunc = useShardFunc;
            return this;
        }
    }
}

