/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ModelDataset", inputsClass=Inputs.class)
public final class ModelDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ModelDataset";
    private Output<? extends TType> handle;

    public ModelDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static ModelDataset create(Scope scope, Operand<? extends TType> inputDataset, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.algorithm != null) {
                    opBuilder.setAttr("algorithm", opts.algorithm);
                }
                if (opts.cpuBudget != null) {
                    opBuilder.setAttr("cpu_budget", opts.cpuBudget);
                }
                if (opts.ramBudget == null) continue;
                opBuilder.setAttr("ram_budget", opts.ramBudget);
            }
        }
        return new ModelDataset(opBuilder.build());
    }

    public static Options algorithm(Long algorithm) {
        return new Options().algorithm(algorithm);
    }

    public static Options cpuBudget(Long cpuBudget) {
        return new Options().cpuBudget(cpuBudget);
    }

    public static Options ramBudget(Long ramBudget) {
        return new Options().ramBudget(ramBudget);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=ModelDataset.class)
    public static class Inputs
    extends RawOpInputs<ModelDataset> {
        public final Operand<? extends TType> inputDataset;
        public final long algorithm;
        public final long cpuBudget;
        public final long ramBudget;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new ModelDataset(op), op, Arrays.asList("algorithm", "cpu_budget", "ram_budget", "output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.algorithm = op.attributes().getAttrInt("algorithm");
            this.cpuBudget = op.attributes().getAttrInt("cpu_budget");
            this.ramBudget = op.attributes().getAttrInt("ram_budget");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }

    public static class Options {
        private Long algorithm;
        private Long cpuBudget;
        private Long ramBudget;

        private Options() {
        }

        public Options algorithm(Long algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Options cpuBudget(Long cpuBudget) {
            this.cpuBudget = cpuBudget;
            return this;
        }

        public Options ramBudget(Long ramBudget) {
            this.ramBudget = ramBudget;
            return this;
        }
    }
}

