/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Unpack", inputsClass=Inputs.class)
public final class Unstack<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "Unpack";
    private List<Output<T>> output;

    public Unstack(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static <T extends TType> Unstack<T> create(Scope scope, Operand<T> value, Long num, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Unstack");
        opBuilder.addInput(value.asOutput());
        opBuilder.setAttr("num", num);
        if (options != null) {
            for (Options opts : options) {
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new Unstack<T>(opBuilder.build());
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=Unstack.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Unstack<T>> {
        public final Operand<T> value;
        public final DataType T;
        public final long axis;

        public Inputs(GraphOperation op) {
            super(new Unstack(op), op, Arrays.asList("T", "axis"));
            int inputIndex = 0;
            this.value = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.axis = op.attributes().getAttrInt("axis");
        }
    }

    public static class Options {
        private Long axis;

        private Options() {
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }
    }
}

