/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="UniqueV2", inputsClass=Inputs.class)
public final class Unique<T extends TType, V extends TNumber>
extends RawOp {
    public static final String OP_NAME = "UniqueV2";
    private Output<T> y;
    private Output<V> idx;

    public Unique(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.y = operation.output(outputIdx++);
        this.idx = operation.output(outputIdx++);
    }

    public static <T extends TType, V extends TNumber> Unique<T, V> create(Scope scope, Operand<T> x, Operand<? extends TNumber> axis, Class<V> outIdx) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Unique");
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(axis.asOutput());
        opBuilder.setAttr("out_idx", Operands.toDataType(outIdx));
        return new Unique<T, V>(opBuilder.build());
    }

    public static <T extends TType> Unique<T, TInt32> create(Scope scope, Operand<T> x, Operand<? extends TNumber> axis) {
        return Unique.create(scope, x, axis, TInt32.class);
    }

    public Output<T> y() {
        return this.y;
    }

    public Output<V> idx() {
        return this.idx;
    }

    @OpInputsMetadata(outputsClass=Unique.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Unique<T, ?>> {
        public final Operand<T> x;
        public final Operand<? extends TNumber> axis;
        public final DataType T;
        public final DataType Taxis;
        public final DataType outIdx;

        public Inputs(GraphOperation op) {
            super(new Unique(op), op, Arrays.asList("T", "Taxis", "out_idx"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.axis = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Taxis = op.attributes().getAttrType("Taxis");
            this.outIdx = op.attributes().getAttrType("out_idx");
        }
    }
}

