/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.op.core.If;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="StatelessIf", inputsClass=Inputs.class)
public final class StatelessIf
extends RawOp
implements If {
    public static final String OP_NAME = "StatelessIf";
    private List<Output<?>> output;

    public StatelessIf(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static StatelessIf create(Scope scope, Operand<? extends TType> cond, Iterable<Operand<?>> input, List<Class<? extends TType>> Tout, ConcreteFunction thenBranch, ConcreteFunction elseBranch, If.Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(cond.asOutput());
        opBuilder.addInputList(Operands.asOutputs(input));
        opBuilder.setAttr("Tout", Operands.toDataTypes(Tout));
        opBuilder.setAttr("then_branch", thenBranch);
        opBuilder.setAttr("else_branch", elseBranch);
        if (options != null) {
            for (If.Options opts : options) {
                if (opts.outputShapes == null) continue;
                Shape[] outputShapesArray = new Shape[opts.outputShapes.size()];
                for (int i = 0; i < outputShapesArray.length; ++i) {
                    outputShapesArray[i] = opts.outputShapes.get(i);
                }
                opBuilder.setAttr("output_shapes", outputShapesArray);
            }
        }
        return new StatelessIf(opBuilder.build());
    }

    @Override
    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=StatelessIf.class)
    public static class Inputs
    extends RawOpInputs<StatelessIf> {
        public final Operand<? extends TType> cond;
        public final Iterable<Operand<?>> input;
        public final DataType Tcond;
        public final DataType[] Tin;
        public final DataType[] Tout;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new StatelessIf(op), op, Arrays.asList("Tcond", "Tin", "Tout", "output_shapes"));
            int inputIndex = 0;
            this.cond = op.input(inputIndex++);
            int inputLength = op.inputListLength("input");
            this.input = Arrays.asList((Operand[])op.inputList(inputIndex, inputLength));
            inputIndex += inputLength;
            this.Tcond = op.attributes().getAttrType("Tcond");
            this.Tin = op.attributes().getAttrTypeList("Tin");
            this.Tout = op.attributes().getAttrTypeList("Tout");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

