/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Pack", inputsClass=Inputs.class)
public final class Stack<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Pack";
    private Output<T> output;

    public Stack(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Stack<T> create(Scope scope, Iterable<Operand<T>> values, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Stack");
        opBuilder.addInputList(Operands.asOutputs(values));
        if (options != null) {
            for (Options opts : options) {
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new Stack<T>(opBuilder.build());
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Stack.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Stack<T>> {
        public final Iterable<Operand<T>> values;
        public final DataType T;
        public final long axis;

        public Inputs(GraphOperation op) {
            super(new Stack(op), op, Arrays.asList("T", "axis"));
            int inputIndex = 0;
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex, valuesLength));
            inputIndex += valuesLength;
            this.T = op.attributes().getAttrType("T");
            this.axis = op.attributes().getAttrInt("axis");
        }
    }

    public static class Options {
        private Long axis;

        private Options() {
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }
    }
}

