/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MapClear", inputsClass=Inputs.class)
public final class MapClear
extends RawOp {
    public static final String OP_NAME = "MapClear";

    public MapClear(Operation operation) {
        super(operation, OP_NAME);
    }

    public static MapClear create(Scope scope, List<Class<? extends TType>> dtypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("dtypes", Operands.toDataTypes(dtypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.memoryLimit != null) {
                    opBuilder.setAttr("memory_limit", opts.memoryLimit);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new MapClear(opBuilder.build());
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options memoryLimit(Long memoryLimit) {
        return new Options().memoryLimit(memoryLimit);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    @OpInputsMetadata(outputsClass=MapClear.class)
    public static class Inputs
    extends RawOpInputs<MapClear> {
        public final long capacity;
        public final long memoryLimit;
        public final DataType[] dtypes;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new MapClear(op), op, Arrays.asList("capacity", "memory_limit", "dtypes", "container", "shared_name"));
            boolean inputIndex = false;
            this.capacity = op.attributes().getAttrInt("capacity");
            this.memoryLimit = op.attributes().getAttrInt("memory_limit");
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private Long capacity;
        private Long memoryLimit;
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options memoryLimit(Long memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

