/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.FloatNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class FloatSparseSlice
extends SparseSlice<Float, FloatNdArray>
implements FloatNdArray {
    public FloatSparseSlice(AbstractSparseNdArray<Float, FloatNdArray> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public FloatNdArray toDense() {
        FloatDataBuffer dataBuffer = DataBuffers.ofFloats(this.shape().size());
        this.copyTo(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    @Override
    public float getFloat(long ... coordinates) {
        return ((Float)this.getObject(coordinates)).floatValue();
    }

    @Override
    public FloatNdArray setFloat(float value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray setObject(Float value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray set(NdArray<Float> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray copyTo(DataBuffer<Float> dst) {
        Object[] defaults = new Float[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write((Float[])defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            float value = ((FloatNdArray)this.getValues()).getFloat(i.getAndIncrement());
            dst.setObject(Float.valueOf(value), this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public FloatNdArray copyTo(FloatDataBuffer dst) {
        return this.copyTo((DataBuffer)dst);
    }

    @Override
    public FloatNdArray copyFrom(DataBuffer<Float> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray copyFrom(FloatDataBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public FloatNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new FloatSparseSlice(this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public FloatNdArray get(long ... coordinates) {
        return (FloatNdArray)super.get(coordinates);
    }

    @Override
    public FloatNdArray copyTo(NdArray<Float> dst) {
        return (FloatNdArray)super.copyTo(dst);
    }

    @Override
    public FloatNdArray createDefaultArray() {
        return (FloatNdArray)this.source.getDefaultArray();
    }
}

