/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.LongSparseSlice;
import org.tensorflow.ndarray.index.Index;

public class LongSparseNdArray
extends AbstractSparseNdArray<Long, LongNdArray>
implements LongNdArray {
    protected LongSparseNdArray(LongNdArray indices, LongNdArray values, long defaultValue, DimensionalSpace dimensions) {
        super(indices, values, defaultValue, dimensions);
    }

    LongSparseNdArray(LongNdArray indices, LongNdArray values, DimensionalSpace dimensions) {
        this(indices, values, 0L, dimensions);
    }

    LongSparseNdArray(LongDataBuffer dataBuffer, DimensionalSpace dimensions) {
        this(dataBuffer, 0L, dimensions);
    }

    LongSparseNdArray(LongDataBuffer dataBuffer, long defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.copyFrom(dataBuffer);
    }

    LongSparseNdArray(DimensionalSpace dimensions) {
        this(0L, dimensions);
    }

    LongSparseNdArray(long defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
    }

    public static LongSparseNdArray create(LongNdArray indices, LongNdArray values, DimensionalSpace dimensions) {
        return new LongSparseNdArray(indices, values, dimensions);
    }

    public static LongSparseNdArray create(LongNdArray indices, LongNdArray values, long defaultValue, DimensionalSpace dimensions) {
        return new LongSparseNdArray(indices, values, defaultValue, dimensions);
    }

    public static LongSparseNdArray create(LongDataBuffer dataBuffer, DimensionalSpace dimensions) {
        return new LongSparseNdArray(dataBuffer, dimensions);
    }

    public static LongSparseNdArray create(LongDataBuffer dataBuffer, long defaultValue, DimensionalSpace dimensions) {
        return new LongSparseNdArray(dataBuffer, defaultValue, dimensions);
    }

    public static LongSparseNdArray create(DimensionalSpace dimensions) {
        return new LongSparseNdArray(dimensions);
    }

    public static LongSparseNdArray create(long defaultValue, DimensionalSpace dimensions) {
        return new LongSparseNdArray(defaultValue, dimensions);
    }

    public static LongSparseNdArray create(LongDataBuffer buffer, Shape shape) {
        return new LongSparseNdArray(buffer, DimensionalSpace.create(shape));
    }

    public static LongSparseNdArray create(LongDataBuffer buffer, long defaultValue, Shape shape) {
        return new LongSparseNdArray(buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static LongSparseNdArray create(LongNdArray src) {
        LongDataBuffer buffer = DataBuffers.ofLongs(src.size());
        src.copyTo(buffer);
        return new LongSparseNdArray(buffer, DimensionalSpace.create(src.shape()));
    }

    public static LongSparseNdArray create(LongNdArray src, long defaultValue) {
        LongDataBuffer buffer = DataBuffers.ofLongs(src.size());
        src.copyTo(buffer);
        return new LongSparseNdArray(buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public LongNdArray createValues(Shape shape) {
        return NdArrays.ofLongs(shape);
    }

    @Override
    public LongNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new LongSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public long getLong(long ... coordinates) {
        return (Long)this.getObject(coordinates);
    }

    @Override
    public LongNdArray setLong(long value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray copyTo(DataBuffer<Long> dst) {
        return this.copyTo((LongDataBuffer)dst);
    }

    @Override
    public LongNdArray copyTo(LongDataBuffer dst) {
        Object[] defaults = new Long[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicLong i = new AtomicLong();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            long value = ((LongNdArray)this.getValues()).getLong(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public LongNdArray copyFrom(LongDataBuffer src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<Long> values = new ArrayList<Long>();
        for (long i = 0L; i < src.size(); ++i) {
            if (src.getObject(i).equals(this.getDefaultValue())) continue;
            indices.add(this.toCoordinates(this.dimensions, i));
            values.add(src.getObject(i));
        }
        long[][] indicesArray = new long[indices.size()][];
        long[] valuesArray = new long[values.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (long[])indices.get(i);
            valuesArray[i] = (Long)values.get(i);
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOf(valuesArray));
        return this;
    }

    @Override
    public LongNdArray copyFrom(DataBuffer<Long> src) {
        return this.copyFrom((LongDataBuffer)src);
    }

    @Override
    public LongNdArray toDense() {
        LongDataBuffer dataBuffer = DataBuffers.ofLongs(this.shape().size());
        this.copyTo(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    public LongNdArray fromDense(LongNdArray src) {
        LongDataBuffer buffer = DataBuffers.ofLongs(src.size());
        src.copyTo(buffer);
        this.copyFrom(buffer);
        return this;
    }

    @Override
    public LongNdArray slice(Index ... indices) {
        return (LongNdArray)super.slice(indices);
    }

    @Override
    public LongNdArray get(long ... coordinates) {
        return (LongNdArray)super.get(coordinates);
    }

    @Override
    public LongNdArray setObject(Long value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray set(NdArray<Long> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray copyTo(NdArray<Long> dst) {
        return (LongNdArray)super.copyTo(dst);
    }

    @Override
    public LongNdArray createDefaultArray() {
        return NdArrays.scalarOf((Long)this.getDefaultValue());
    }
}

