/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.EagerSession;
import org.tensorflow.Tensor;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.internal.types.registry.TensorTypeInfo;
import org.tensorflow.internal.types.registry.TensorTypeRegistry;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

public final class RawTensor
implements Tensor {
    private PointerScope tensorScope;
    private TF_Tensor tensorHandle;
    private final TensorTypeInfo<? extends TType> typeInfo;
    private final Shape shape;
    private ByteDataBuffer buffer = null;

    @Override
    public DataType dataType() {
        return this.typeInfo.dataType();
    }

    @Override
    public long numBytes() {
        return tensorflow.TF_TensorByteSize(this.nativeHandle());
    }

    @Override
    public Shape shape() {
        return this.shape;
    }

    @Override
    public RawTensor asRawTensor() {
        return this;
    }

    @Override
    public void close() {
        this.tensorScope.close();
    }

    public ByteDataBuffer data() {
        if (this.buffer == null) {
            this.buffer = TensorBuffers.toBytes(this.nativeHandle());
        }
        return this.buffer;
    }

    public String toString() {
        return String.format("%s tensor with shape %s", new Object[]{this.typeInfo.dataType(), this.shape});
    }

    static RawTensor allocate(Class<? extends TType> type, Shape shape, long size) {
        if (shape.hasUnknownDimension()) {
            throw new IllegalArgumentException("Cannot allocate a tensor from a totally or partially unknown shape");
        }
        TensorTypeInfo<? extends TType> typeInfo = TensorTypeRegistry.find(type);
        long allocatedSize = size;
        if (allocatedSize < 0L) {
            if (typeInfo.isVariableLength()) {
                throw new IllegalArgumentException("Explicit size is required for variable-length tensor types");
            }
            allocatedSize = shape.size() * (long)typeInfo.byteSize();
        } else if (!typeInfo.isVariableLength() && shape.size() * (long)typeInfo.byteSize() > allocatedSize) {
            throw new IllegalArgumentException("Tensor size is not large enough to contain all scalar values");
        }
        TF_Tensor nativeHandle = RawTensor.allocate(typeInfo.dataType().getNumber(), shape.asArray(), allocatedSize);
        try (PointerScope scope = new PointerScope();){
            scope.attach((Pointer)nativeHandle);
            RawTensor t = new RawTensor(typeInfo, shape);
            t.tensorHandle = nativeHandle;
            t.tensorScope = scope.extend();
            RawTensor rawTensor = t;
            return rawTensor;
        }
    }

    static RawTensor fromHandle(TF_Tensor handle) {
        TensorTypeInfo typeInfo = TensorTypeRegistry.find(DataType.forNumber(RawTensor.dtype(handle)));
        RawTensor t = new RawTensor(typeInfo, Shape.of(RawTensor.shape(handle)));
        try (PointerScope scope = new PointerScope();){
            scope.attach((Pointer)handle);
            t.tensorHandle = handle;
            t.tensorScope = scope.extend();
        }
        return t;
    }

    static RawTensor fromHandle(TF_Tensor handle, EagerSession session) {
        RawTensor t = RawTensor.fromHandle(handle);
        session.attach(handle);
        t.tensorScope.detach((Pointer)handle);
        return t;
    }

    TF_Tensor nativeHandle() {
        return RawTensor.requireHandle(this.tensorHandle);
    }

    TType asTypedTensor() {
        return this.typeInfo.mapper().mapDense(this);
    }

    TensorTypeInfo<? extends TType> typeInfo() {
        return this.typeInfo;
    }

    private static TF_Tensor requireHandle(TF_Tensor handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() was called on the Tensor");
        }
        return handle;
    }

    private static TF_Tensor allocate(int dtype, long[] shape, long byteSize) {
        TF_Tensor t = TF_Tensor.allocateTensor(dtype, shape, byteSize);
        if (t == null || t.isNull()) {
            throw new IllegalStateException("unable to allocate memory for the Tensor");
        }
        return t;
    }

    private static int dtype(TF_Tensor handle) {
        RawTensor.requireHandle(handle);
        return tensorflow.TF_TensorType(handle);
    }

    private static long[] shape(TF_Tensor handle) {
        RawTensor.requireHandle(handle);
        int numDims = tensorflow.TF_NumDims(handle);
        long[] dims = new long[numDims];
        for (int i = 0; i < numDims; ++i) {
            dims[i] = tensorflow.TF_Dim(handle, i);
        }
        return dims;
    }

    RawTensor(TensorTypeInfo<? extends TType> typeInfo, Shape shape) {
        this.typeInfo = typeInfo;
        this.shape = shape;
    }

    static {
        try {
            Class.forName("org.tensorflow.TensorFlow");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

