/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSelectAndScatter", inputsClass=Inputs.class)
public final class SelectAndScatter<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaSelectAndScatter";
    private Output<T> output;

    public SelectAndScatter(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TNumber> SelectAndScatter<T> create(Scope scope, Operand<T> operand, Operand<U> windowDimensions, Operand<U> windowStrides, Operand<U> padding, Operand<T> source, Operand<T> initValue, ConcreteFunction select, ConcreteFunction scatter) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SelectAndScatter");
        opBuilder.addInput(operand.asOutput());
        opBuilder.addInput(windowDimensions.asOutput());
        opBuilder.addInput(windowStrides.asOutput());
        opBuilder.addInput(padding.asOutput());
        opBuilder.addInput(source.asOutput());
        opBuilder.addInput(initValue.asOutput());
        opBuilder.setAttr("select", select);
        opBuilder.setAttr("scatter", scatter);
        return new SelectAndScatter<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SelectAndScatter.class)
    public static class Inputs<T extends TType, U extends TNumber>
    extends RawOpInputs<SelectAndScatter<T>> {
        public final Operand<T> operand;
        public final Operand<U> windowDimensions;
        public final Operand<U> windowStrides;
        public final Operand<U> padding;
        public final Operand<T> source;
        public final Operand<T> initValue;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new SelectAndScatter(op), op, Arrays.asList("T", "Tindices"));
            int inputIndex = 0;
            this.operand = op.input(inputIndex++);
            this.windowDimensions = op.input(inputIndex++);
            this.windowStrides = op.input(inputIndex++);
            this.padding = op.input(inputIndex++);
            this.source = op.input(inputIndex++);
            this.initValue = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

