/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="XlaReduceScatter", inputsClass=Inputs.class)
public final class ReduceScatter<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaReduceScatter";
    private Output<T> output;

    public ReduceScatter(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ReduceScatter<T> create(Scope scope, Operand<T> input, Operand<TInt32> groupAssignment, Operand<TInt32> scatterDimension, String reduceOp) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ReduceScatter");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(groupAssignment.asOutput());
        opBuilder.addInput(scatterDimension.asOutput());
        opBuilder.setAttr("reduce_op", reduceOp);
        return new ReduceScatter<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ReduceScatter.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ReduceScatter<T>> {
        public final Operand<T> input;
        public final Operand<TInt32> groupAssignment;
        public final Operand<TInt32> scatterDimension;
        public final DataType T;
        public final String reduceOp;

        public Inputs(GraphOperation op) {
            super(new ReduceScatter(op), op, Arrays.asList("T", "reduce_op"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.groupAssignment = op.input(inputIndex++);
            this.scatterDimension = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.reduceOp = op.attributes().getAttrString("reduce_op");
        }
    }
}

