/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaRecv", inputsClass=Inputs.class)
public final class Recv<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaRecv";
    private Output<T> tensor;

    public Recv(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static <T extends TType> Recv<T> create(Scope scope, Class<T> dtype, String tensorName, Shape shape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Recv");
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        opBuilder.setAttr("tensor_name", tensorName);
        opBuilder.setAttr("shape", shape);
        return new Recv<T>(opBuilder.build());
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    @OpInputsMetadata(outputsClass=Recv.class)
    public static class Inputs
    extends RawOpInputs<Recv<?>> {
        public final DataType dtype;
        public final String tensorName;
        public final Shape shape;

        public Inputs(GraphOperation op) {
            super(new Recv(op), op, Arrays.asList("dtype", "tensor_name", "shape"));
            boolean inputIndex = false;
            this.dtype = op.attributes().getAttrType("dtype");
            this.tensorName = op.attributes().getAttrString("tensor_name");
            this.shape = op.attributes().getAttrShape("shape");
        }
    }
}

