/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaDynamicSlice", inputsClass=Inputs.class)
public final class DynamicSlice<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaDynamicSlice";
    private Output<T> output;

    public DynamicSlice(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TNumber> DynamicSlice<T> create(Scope scope, Operand<T> input, Operand<U> startIndices, Operand<U> sizeIndices) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DynamicSlice");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(startIndices.asOutput());
        opBuilder.addInput(sizeIndices.asOutput());
        return new DynamicSlice<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DynamicSlice.class)
    public static class Inputs<T extends TType, U extends TNumber>
    extends RawOpInputs<DynamicSlice<T>> {
        public final Operand<T> input;
        public final Operand<U> startIndices;
        public final Operand<U> sizeIndices;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new DynamicSlice(op), op, Arrays.asList("T", "Tindices"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.startIndices = op.input(inputIndex++);
            this.sizeIndices = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

