/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaCustomCall", inputsClass=Inputs.class)
public final class CustomCall<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaCustomCall";
    private Output<T> output;

    public CustomCall(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> CustomCall<T> create(Scope scope, Iterable<Operand<?>> args, String targetName, String backendConfig, Class<T> dtype, Shape shape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CustomCall");
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.setAttr("target_name", targetName);
        opBuilder.setAttr("backend_config", backendConfig);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        opBuilder.setAttr("shape", shape);
        return new CustomCall<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=CustomCall.class)
    public static class Inputs
    extends RawOpInputs<CustomCall<?>> {
        public final Iterable<Operand<?>> args;
        public final String targetName;
        public final String backendConfig;
        public final DataType[] T;
        public final DataType dtype;
        public final Shape shape;

        public Inputs(GraphOperation op) {
            super(new CustomCall(op), op, Arrays.asList("target_name", "backend_config", "T", "dtype", "shape"));
            int inputIndex = 0;
            int argsLength = op.inputListLength("args");
            this.args = Arrays.asList((Operand[])op.inputList(inputIndex, argsLength));
            inputIndex += argsLength;
            this.targetName = op.attributes().getAttrString("target_name");
            this.backendConfig = op.attributes().getAttrString("backend_config");
            this.T = op.attributes().getAttrTypeList("T");
            this.dtype = op.attributes().getAttrType("dtype");
            this.shape = op.attributes().getAttrShape("shape");
        }
    }
}

