/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseTensorDenseMatMul", inputsClass=Inputs.class)
public final class SparseTensorDenseMatMul<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "SparseTensorDenseMatMul";
    private Output<U> product;

    public SparseTensorDenseMatMul(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.product = operation.output(outputIdx++);
    }

    public static <U extends TType> SparseTensorDenseMatMul<U> create(Scope scope, Operand<? extends TNumber> aIndices, Operand<U> aValues, Operand<TInt64> aShape, Operand<U> b, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(aIndices.asOutput());
        opBuilder.addInput(aValues.asOutput());
        opBuilder.addInput(aShape.asOutput());
        opBuilder.addInput(b.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.adjointA != null) {
                    opBuilder.setAttr("adjoint_a", opts.adjointA);
                }
                if (opts.adjointB == null) continue;
                opBuilder.setAttr("adjoint_b", opts.adjointB);
            }
        }
        return new SparseTensorDenseMatMul<U>(opBuilder.build());
    }

    public static Options adjointA(Boolean adjointA) {
        return new Options().adjointA(adjointA);
    }

    public static Options adjointB(Boolean adjointB) {
        return new Options().adjointB(adjointB);
    }

    public Output<U> product() {
        return this.product;
    }

    @Override
    public Output<U> asOutput() {
        return this.product;
    }

    @OpInputsMetadata(outputsClass=SparseTensorDenseMatMul.class)
    public static class Inputs<U extends TType>
    extends RawOpInputs<SparseTensorDenseMatMul<U>> {
        public final Operand<? extends TNumber> aIndices;
        public final Operand<U> aValues;
        public final Operand<TInt64> aShape;
        public final Operand<U> b;
        public final DataType T;
        public final DataType Tindices;
        public final boolean adjointA;
        public final boolean adjointB;

        public Inputs(GraphOperation op) {
            super(new SparseTensorDenseMatMul(op), op, Arrays.asList("T", "Tindices", "adjoint_a", "adjoint_b"));
            int inputIndex = 0;
            this.aIndices = op.input(inputIndex++);
            this.aValues = op.input(inputIndex++);
            this.aShape = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
            this.adjointA = op.attributes().getAttrBool("adjoint_a");
            this.adjointB = op.attributes().getAttrBool("adjoint_b");
        }
    }

    public static class Options {
        private Boolean adjointA;
        private Boolean adjointB;

        private Options() {
        }

        public Options adjointA(Boolean adjointA) {
            this.adjointA = adjointA;
            return this;
        }

        public Options adjointB(Boolean adjointB) {
            this.adjointB = adjointB;
            return this;
        }
    }
}

